<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class MemberActivityReportExport implements FromArray, WithHeadings, WithTitle, ShouldAutoSize
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        $rows = [];

        foreach ($this->data as $member) {
            $rows[] = [
                $member['member']->user->full_name,
                $member['member']->user->id_number,
                $member['member']->user->phone_number,
                $member['member']->user->email,
                $member['member']->joining_date->format('Y-m-d'),
                $member['member']->status,
                $member['savings_balance'],
                $member['loan_balance'],
                $member['share_balance'],
                $member['transaction_count'],
                $member['last_activity'] ? $member['last_activity']->format('Y-m-d H:i') : 'Never',
                $member['total_deposits'],
                $member['total_withdrawals'],
            ];
        }

        return $rows;
    }

    public function headings(): array
    {
        return [
            'Member Name',
            'ID Number',
            'Phone',
            'Email',
            'Joining Date',
            'Status',
            'Savings Balance',
            'Loan Balance',
            'Share Balance',
            'Transaction Count',
            'Last Activity',
            'Total Deposits',
            'Total Withdrawals',
        ];
    }

    public function title(): string
    {
        return 'Member Activity Report';
    }
}
