<?php

namespace App\Exports;

use App\Models\Membership;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Border;

class MembershipsExport implements FromCollection, WithHeadings, WithStyles, ShouldAutoSize
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Membership::with('user.branch')->get()->map(function ($membership) {
            return [
                'ID' => $membership->id,
                'Membership Number' => $membership->membership_number,
                'First Name' => $membership->user->first_name ?? 'N/A',
                'Second Name' => $membership->user->second_name ?? 'N/A',
                'Full Name' => $membership->user->full_name ?? 'N/A',
                'Gender' => ucfirst($membership->gender),
                'ID Number' => $membership->user->id_number ?? 'N/A',
                'Phone Number' => $membership->user->phone_number ?? 'N/A',
                'Email' => $membership->user->email ?? 'N/A',
                'Occupation' => $membership->occupation ?? 'N/A',
                'Branch' => $membership->user->branch->name ?? 'N/A',
                'Joining Date' => $membership->joining_date ? $membership->joining_date->format('d M Y') : 'N/A',
                'Status' => ucfirst($membership->status),
                'Share Capital' => 'KSh ' . number_format($membership->share_capital, 2),
                'Savings Balance' => 'KSh ' . number_format($membership->savings_balance, 2),
                'Registration Fee' => 'KSh ' . number_format($membership->registration_fee, 2),
                'Registration Fee Status' => ucfirst($membership->registration_fee_status),
                'Notes' => $membership->notes ?? 'N/A',
                'Created At' => $membership->created_at->format('d M Y H:i'),
            ];
        });
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Membership Number',
            'First Name',
            'Second Name',
            'Full Name',
            'Gender',
            'ID Number',
            'Phone Number',
            'Email',
            'Occupation',
            'Branch',
            'Joining Date',
            'Status',
            'Share Capital',
            'Savings Balance',
            'Registration Fee',
            'Registration Fee Status',
            'Notes',
            'Created At',
        ];
    }

    /**
     * @param Worksheet $sheet
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the header row
            1 => [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 12,
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '247F1B'], // Primary color #247f1b
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => '000000'],
                    ],
                ],
            ],

            // Style data rows
            'A2:Z1000' => [
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => 'DDDDDD'],
                    ],
                ],
            ],

            // Alternate row colors
            'A3:Z1000' => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'FFF8F8'], // Light secondary color
                ],
            ],
        ];
    }
}
