<?php

namespace App\Exports;

use App\Models\Occupation;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Border;

class OccupationsExport implements FromCollection, WithHeadings, WithStyles, ShouldAutoSize
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Occupation::ordered()->get()->map(function ($occupation) {
            $memberCount = \App\Models\Membership::where('occupation', $occupation->name)->count();

            return [
                'ID' => $occupation->id,
                'Occupation Name' => $occupation->name,
                'Description' => $occupation->description ?? 'N/A',
                'Number of Members' => $memberCount,
                'Sort Order' => $occupation->sort_order,
                'Status' => $occupation->is_active ? 'Active' : 'Inactive',
                'Created At' => $occupation->created_at->format('d M Y H:i'),
                'Updated At' => $occupation->updated_at->format('d M Y H:i'),
            ];
        });
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Occupation Name',
            'Description',
            'Number of Members',
            'Sort Order',
            'Status',
            'Created At',
            'Updated At',
        ];
    }

    /**
     * @param Worksheet $sheet
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the header row
            1 => [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 12,
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '247F1B'], // Primary color #247f1b
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => '000000'],
                    ],
                ],
            ],

            // Style data rows
            'A2:H1000' => [
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => 'DDDDDD'],
                    ],
                ],
            ],

            // Alternate row colors
            'A3:H1000' => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'FFF8F8'], // Light secondary color
                ],
            ],
        ];
    }
}
