<?php

namespace App\Exports;

use App\Models\Share;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class SharesExport implements FromCollection, WithHeadings, WithMapping
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Share::with('user')->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Member Name',
            'Membership Number',
            'Number of Shares',
            'Share Value (KES)',
            'Total Value (KES)',
            'Purchase Date',
            'Notes',
            'Created Date',
        ];
    }

    /**
     * @param mixed $share
     * @return array
     */
    public function map($share): array
    {
        return [
            $share->id,
            $share->user->full_name ?? 'N/A',
            $share->user->membership_number ?? 'N/A',
            $share->number_of_shares,
            $share->share_value,
            $share->total_value,
            $share->purchase_date ? $share->purchase_date->format('Y-m-d') : 'N/A',
            $share->notes ?? '',
            $share->created_at->format('Y-m-d'),
        ];
    }
}
