<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Membership;
use App\Models\Loan;
use App\Models\Saving;
use App\Models\User;
use App\Models\Branch;
use App\Models\Transaction;

class SearchController extends Controller
{
    public function search(Request $request)
    {
        $query = $request->get('q', '');

        if (strlen($query) < 2) {
            return response()->json(['results' => []]);
        }

        $results = [];

        // Search Memberships
        $memberships = Membership::where('full_name', 'LIKE', "%{$query}%")
            ->orWhere('email', 'LIKE', "%{$query}%")
            ->orWhere('phone', 'LIKE', "%{$query}%")
            ->orWhere('id_number', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($memberships as $membership) {
            $results[] = [
                'id' => $membership->id,
                'type' => 'membership',
                'title' => $membership->full_name,
                'subtitle' => 'Membership - ' . $membership->id_number,
                'url' => route('memberships.show', $membership),
                'icon' => 'cil-id-card',
                'color' => 'primary'
            ];
        }

        // Search Loans
        $loans = Loan::with('user')
            ->whereHas('user', function($q) use ($query) {
                $q->where('full_name', 'LIKE', "%{$query}%");
            })
            ->orWhere('loan_number', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($loans as $loan) {
            $results[] = [
                'id' => $loan->id,
                'type' => 'loan',
                'title' => 'Loan #' . $loan->loan_number,
                'subtitle' => $loan->user->full_name ?? 'Unknown' . ' - KSh ' . number_format($loan->amount, 0),
                'url' => route('loans.show', $loan),
                'icon' => 'cil-money',
                'color' => 'warning'
            ];
        }

        // Search Savings
        $savings = Saving::with('user')
            ->whereHas('user', function($q) use ($query) {
                $q->where('full_name', 'LIKE', "%{$query}%");
            })
            ->orWhere('id', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($savings as $saving) {
            $results[] = [
                'id' => $saving->id,
                'type' => 'saving',
                'title' => 'Savings Account',
                'subtitle' => $saving->user->full_name ?? 'Unknown' . ' - KSh ' . number_format($saving->current_balance, 0),
                'url' => route('savings.show', $saving),
                'icon' => 'cil-piggy-bank',
                'color' => 'success'
            ];
        }

        // Search Users
        $users = User::where('full_name', 'LIKE', "%{$query}%")
            ->orWhere('email', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($users as $user) {
            $results[] = [
                'id' => $user->id,
                'type' => 'user',
                'title' => $user->full_name,
                'subtitle' => 'User - ' . $user->email,
                'url' => route('users.show', $user),
                'icon' => 'cil-people',
                'color' => 'info'
            ];
        }

        // Search Branches
        $branches = Branch::where('name', 'LIKE', "%{$query}%")
            ->orWhere('location', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($branches as $branch) {
            $results[] = [
                'id' => $branch->id,
                'type' => 'branch',
                'title' => $branch->name,
                'subtitle' => 'Branch - ' . $branch->location,
                'url' => route('branches.show', $branch),
                'icon' => 'cil-building',
                'color' => 'secondary'
            ];
        }

        // Search Transactions
        $transactions = Transaction::with('user')
            ->whereHas('user', function($q) use ($query) {
                $q->where('full_name', 'LIKE', "%{$query}%");
            })
            ->orWhere('reference', 'LIKE', "%{$query}%")
            ->limit(5)
            ->get();

        foreach ($transactions as $transaction) {
            $results[] = [
                'id' => $transaction->id,
                'type' => 'transaction',
                'title' => 'Transaction #' . $transaction->id,
                'subtitle' => $transaction->user->full_name ?? 'Unknown' . ' - KSh ' . number_format($transaction->amount, 0),
                'url' => route('transactions.show', $transaction),
                'icon' => 'cil-transfer',
                'color' => 'dark'
            ];
        }

        return response()->json(['results' => array_slice($results, 0, 10)]);
    }
}
