<?php

namespace App\Http\Controllers;

use App\Models\SystemConfiguration;
use Illuminate\Http\Request;

class SystemConfigurationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $configurations = SystemConfiguration::orderBy('category')
            ->orderBy('key')
            ->get();

        return view('adminlte.system-configurations.index', compact('configurations'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $configuration = SystemConfiguration::findOrFail($id);

        $request->validate([
            'value' => 'required|string',
        ]);

        // Handle JSON data for occupation options
        if ($configuration->key === 'occupation_options') {
            $occupations = array_map('trim', explode("\n", $request->value));
            $occupations = array_filter($occupations); // Remove empty lines
            $configuration->value = json_encode(array_values($occupations));
        } else {
            $configuration->value = $request->value;
        }

        $configuration->save();

        return redirect()->route('system-configurations.index')
                        ->with('success', 'Configuration updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
