<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Models\Loan;
use App\Models\Transaction;

class LoanRepaymentReceipt extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $loan;
    public $transaction;

    /**
     * Create a new message instance.
     */
    public function __construct(User $user, Loan $loan, Transaction $transaction)
    {
        $this->user = $user;
        $this->loan = $loan;
        $this->transaction = $transaction;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Morio Sacco - Loan Repayment Receipt',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.loan-repayment-receipt',
            with: [
                'user' => $this->user,
                'loan' => $this->loan,
                'transaction' => $this->transaction,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
