<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Models\Membership;
use App\Models\Transaction;

class RegistrationFeePaymentReceipt extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $membership;
    public $transaction;

    /**
     * Create a new message instance.
     */
    public function __construct(User $user, Membership $membership, Transaction $transaction)
    {
        $this->user = $user;
        $this->membership = $membership;
        $this->transaction = $transaction;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Morio Sacco - Registration Fee Payment Receipt',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.registration-fee-receipt',
            with: [
                'user' => $this->user,
                'membership' => $this->membership,
                'transaction' => $this->transaction,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
