<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('memberships', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('membership_number')->unique();
            $table->date('joining_date');
            $table->enum('status', ['active', 'inactive', 'suspended'])->default('active');
            $table->decimal('share_capital', 15, 2)->default(0);
            $table->decimal('savings_balance', 15, 2)->default(0);
            $table->text('notes')->nullable();
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('memberships');
    }
};
