<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_guarantors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('loan_id');
            $table->unsignedBigInteger('guarantor_user_id'); // The member who is guaranteeing
            $table->decimal('guarantee_amount', 15, 2); // Amount the guarantor is guaranteeing
            $table->enum('relationship_type', ['family', 'friend', 'colleague', 'other'])->default('other');
            $table->text('relationship_details')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('approval_notes')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->foreign('loan_id')->references('id')->on('loans')->onDelete('cascade');
            $table->foreign('guarantor_user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loan_guarantors', function (Blueprint $table) {
            $table->dropForeign(['loan_id']);
            $table->dropForeign(['guarantor_user_id']);
            $table->dropForeign(['approved_by']);
        });
        Schema::dropIfExists('loan_guarantors');
    }
};
