<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update existing 'loan_repayment' to 'loan_payment'
        DB::table('transactions')->where('type', 'loan_repayment')->update(['type' => 'loan_payment']);

        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('loan_request', 'loan_payment', 'savings_deposit', 'savings_withdrawal', 'registration_fee', 'share_purchase', 'dividend_payment', 'interest_payment', 'fee_payment', 'mpesa_deposit', 'mpesa_withdrawal', 'account_transfer', 'loan_disbursement', 'other') NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Update 'loan_payment' back to 'loan_repayment'
        DB::table('transactions')->where('type', 'loan_payment')->update(['type' => 'loan_repayment']);

        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('loan_request', 'loan_repayment', 'savings_deposit', 'savings_withdrawal') NOT NULL");
    }
};
