<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('money_market_accounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('membership_id')->constrained('memberships')->onDelete('cascade');
            $table->string('account_number')->unique();
            $table->decimal('principal_amount', 15, 2);
            $table->decimal('interest_rate', 5, 2); // Annual interest rate (e.g., 8.50 for 8.5%)
            $table->integer('term_months'); // Investment term in months
            $table->date('start_date');
            $table->date('maturity_date');
            $table->decimal('interest_earned', 15, 2)->default(0);
            $table->decimal('total_amount', 15, 2)->default(0); // Principal + Interest
            $table->enum('status', ['active', 'matured', 'withdrawn', 'cancelled'])->default('active');
            $table->string('currency_code', 3)->default('KES');
            $table->text('notes')->nullable();
            $table->timestamp('withdrawn_at')->nullable();
            $table->decimal('withdrawal_amount', 15, 2)->nullable();
            $table->timestamps();

            // Indexes for performance
            $table->index(['membership_id', 'status']);
            $table->index('maturity_date');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('money_market_accounts');
    }
};
