<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Branch;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a branch if it doesn't exist
        $branch = Branch::firstOrCreate([
            'name' => 'Nairobi Main Branch'
        ], [
            'location' => 'Nairobi CBD',
            'description' => 'Main administrative branch'
        ]);

        // Create admin user
        User::firstOrCreate([
            'email' => 'admin@morio-sacco.com'
        ], [
            'name' => 'Admin User',
            'first_name' => 'Admin',
            'second_name' => 'User',
            'phone_number' => '+254700000000',
            'id_number' => '00000000',
            'password' => bcrypt('password'),
            'role' => 'admin',
            'branch_id' => $branch->id,
        ]);

        $this->command->info('Admin user created successfully!');
        $this->command->info('Email: admin@morio-sacco.com');
        $this->command->info('Password: password');
    }
}
