<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Membership;

class MemberSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a sample member
        $user = User::create([
            'name' => 'John Doe',
            'first_name' => 'John',
            'second_name' => 'Doe',
            'phone_number' => '+254712345678',
            'id_number' => '12345678',
            'email' => 'john.doe@morio-sacco.com',
            'password' => bcrypt('password123'),
            'role' => 'member',
            'branch_id' => 1
        ]);

        $user->assignRole('Member');

        Membership::create([
            'user_id' => $user->id,
            'gender' => 'male',
            'occupation' => 'Software Developer',
            'membership_number' => 'MS001',
            'joining_date' => now(),
            'status' => 'active',
            'share_capital' => 5000,
            'savings_balance' => 15000,
            'registration_fee' => 1000,
            'registration_fee_status' => 'paid'
        ]);

        $this->command->info('Sample member created successfully!');
        $this->command->info('Email: john.doe@morio-sacco.com');
        $this->command->info('Password: password123');
    }
}
