<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class OccupationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $occupations = [
            [
                'name' => 'Teacher',
                'description' => 'Educational professional working in schools or institutions',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Doctor',
                'description' => 'Medical professional providing healthcare services',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Nurse',
                'description' => 'Healthcare professional assisting in medical care',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Engineer',
                'description' => 'Professional in engineering and technical fields',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Accountant',
                'description' => 'Financial professional handling accounting and finance',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Business Owner',
                'description' => 'Entrepreneur running their own business',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Farmer',
                'description' => 'Agricultural professional involved in farming activities',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Driver',
                'description' => 'Professional driver in transportation services',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Mechanic',
                'description' => 'Automotive technician and repair specialist',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Student',
                'description' => 'Currently pursuing education',
                'is_active' => true,
                'sort_order' => 10,
            ],
            [
                'name' => 'Retired',
                'description' => 'Retired from professional work',
                'is_active' => true,
                'sort_order' => 11,
            ],
            [
                'name' => 'Self-Employed',
                'description' => 'Working independently or freelance',
                'is_active' => true,
                'sort_order' => 12,
            ],
        ];

        foreach ($occupations as $occupation) {
            \App\Models\Occupation::create($occupation);
        }
    }
}
