<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            // User management permissions
            'view users',
            'create users',
            'edit users',
            'delete users',

            // Membership permissions
            'view memberships',
            'create memberships',
            'edit memberships',
            'delete memberships',

            // Branch permissions
            'view branches',
            'create branches',
            'edit branches',
            'delete branches',

            // Loan permissions
            'view loans',
            'create loans',
            'edit loans',
            'approve loans',

            // Savings permissions
            'view savings',
            'create savings',
            'edit savings',

            // Transaction permissions
            'view transactions',
            'create transactions',

            // System settings permissions
            'view system settings',
            'edit system settings',

            // M-Pesa permissions
            'view mpesa settings',
            'edit mpesa settings',


            // Reports permissions
            'view reports',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign permissions to roles
        $adminRole = Role::where('name', 'Admin')->first();
        if ($adminRole) {
            $adminRole->syncPermissions($permissions); // Admin gets all permissions
        }

        $loanManagerRole = Role::where('name', 'Loan Manager')->first();
        if ($loanManagerRole) {
            $loanManagerRole->syncPermissions([
                'view users',
                'view memberships',
                'view branches',
                'view loans',
                'create loans',
                'edit loans',
                'approve loans',
                'view savings',
                'view transactions',
                'view reports',
            ]);
        }

        $frontOfficeRole = Role::where('name', 'Front Office')->first();
        if ($frontOfficeRole) {
            $frontOfficeRole->syncPermissions([
                'view users',
                'create users',
                'edit users',
                'view memberships',
                'create memberships',
                'edit memberships',
                'view branches',
                'view loans',
                'view savings',
                'create savings',
                'view transactions',
                'create transactions',
            ]);
        }

        $memberRole = Role::where('name', 'Member')->first();
        if ($memberRole) {
            $memberRole->syncPermissions([
                'view memberships', // Can view their own membership
                'view loans', // Can view their own loans
                'view savings', // Can view their own savings
                'view transactions', // Can view their own transactions
            ]);
        }

        $this->command->info('Permissions created and assigned to roles successfully!');
    }
}
