<p align="center">
  <a href="https://coreui.io/">
    <img src="https://coreui.io/images/brand/coreui-signet.svg" alt="CoreUI logo" width="200">
  </a>
</p>

<h3 align="center">CoreUI</h3>

<p align="center">
  An advanced UI library based on Bootstrap 5 – CoreUI extends Bootstrap with PRO components, and ready-to-use admin templates for React, Angular, Vue, and more.
  <br>
  <a href="https://coreui.io/bootstrap/docs/"><strong>Explore CoreUI docs »</strong></a>
  <br>
  <br>
  <a href="https://github.com/coreui/coreui/issues/new?template=bug_report.md">Report bug</a>
  ·
  <a href="https://github.com/coreui/coreui/issues/new?template=feature_request.md">Request feature</a>
  ·
  <a href="https://coreui.requestshub.com/p/coreui-for-bootstrap/roadmap">Roadmap</a>
  ·
  <a href="https://coreui.io/blog/">Blog</a>
</p>

## CoreUI vs Bootstrap

CoreUI is fully compatible with Bootstrap, but it’s more than just a theme or UI extension — it’s a professionally developed and maintained system that addresses many of the limitations developers face with Bootstrap alone.

**Key differences between CoreUI and Bootstrap:**

* ✅ **Framework-native versions** – CoreUI offers official libraries for [React.js](https://coreui.io/react/), [Vue.js](https://coreui.io/vue/), and [Angular](https://coreui.io/angular/), while Bootstrap depends on third-party community plugins for framework integration.
* 👨‍💻 **Full-time maintained project** – CoreUI is not a community-only initiative. It’s developed by a dedicated, full-time team focused on long-term evolution and support.
* 📦 **More built-in components** – CoreUI includes many components not present in Bootstrap by default, such as range sliders, multi-selects, and step-based form wizards.
* 🛠️ **Sass Modules support today** – CoreUI already supports Sass Modules out of the box, a feature that Bootstrap plans to introduce in version 6.
* 🌍 **Modern RTL/LTR support** – CoreUI uses CSS logical properties to provide seamless RTL and LTR layout support for multilingual and internationalized apps.
* 🔒 **Long-Term Support (LTS)** – While Bootstrap 3 & 4 LTS is now a paid service via [HeroDevs](https://www.herodevs.com/support/nes-bootstrap?utm_source=Bootstrap_site&utm_medium=Banner&utm_campaign=v3and4_eol), CoreUI continues to offer long-term support without additional cost.

Whether you're starting a new project or migrating from Bootstrap, CoreUI gives you a powerful upgrade path with more features, framework bindings, and peace of mind for long-term maintainability.

## Table of contents

- [Table of contents](#table-of-contents)
- [Quick start](#quick-start)
- [Components](#components)
- [Status](#status)
- [What's included](#whats-included)
- [Bugs and feature requests](#bugs-and-feature-requests)
- [Documentation](#documentation)
- [Frameworks](#frameworks)
- [Templates](#templates)
- [Contributing](#contributing)
- [Community](#community)
- [Versioning](#versioning)
- [Creators](#creators)
- [Thanks](#thanks)
- [Support CoreUI Development](#support-coreui-development)
- [Copyright and license](#copyright-and-license)

## Quick start

Several quick start options are available:

- [Download the latest release](https://github.com/coreui/coreui/archive/v5.4.3.zip)
- Clone the repo: `git clone https://github.com/coreui/coreui.git`
- Install with [npm](https://www.npmjs.com/): `npm install @coreui/coreui`
- Install with [yarn](https://yarnpkg.com/): `yarn add @coreui/coreui`
- Install with [Composer](https://getcomposer.org/): `composer require coreui/coreui:5.4.3`

Read the [Getting started page](https://coreui.io/docs/getting-started/introduction/) for information on the framework contents, templates and examples, and more.

## Components

- [Bootstrap Accordion](https://coreui.io/bootstrap/docs/components/accordion/)
- [Bootstrap Alert](https://coreui.io/bootstrap/docs/components/alert/)
- [Bootstrap Autocomplete](https://coreui.io/bootstrap/docs/forms/autocomplete/) **PRO**
- [Bootstrap Avatar](https://coreui.io/bootstrap/docs/components/avatar/)
- [Bootstrap Badge](https://coreui.io/bootstrap/docs/components/badge/)
- [Bootstrap Breadcrumb](https://coreui.io/bootstrap/docs/components/breadcrumb/)
- [Bootstrap Button](https://coreui.io/bootstrap/docs/components/button/)
- [Bootstrap Button Group](https://coreui.io/bootstrap/docs/components/button-group/)
- [Bootstrap Callout](https://coreui.io/bootstrap/docs/components/callout/)
- [Bootstrap Card](https://coreui.io/bootstrap/docs/components/card/)
- [Bootstrap Carousel](https://coreui.io/bootstrap/docs/components/carousel/)
- [Bootstrap Checkbox](https://coreui.io/bootstrap/docs/forms/checkbox/)
- [Bootstrap Close Button](https://coreui.io/bootstrap/docs/components/close-button/)
- [Bootstrap Calendar](https://coreui.io/bootstrap/docs/components/calendar/) **PRO**
- [Bootstrap Collapse](https://coreui.io/bootstrap/docs/components/collapse/)
- [Bootstrap Date Picker](https://coreui.io/bootstrap/docs/forms/date-picker/) **PRO**
- [Bootstrap Date Range Picker](https://coreui.io/bootstrap/docs/forms/date-range-picker/) **PRO**
- [Bootstrap Dropdown](https://coreui.io/bootstrap/docs/components/dropdown/)
- [Bootstrap Floating Labels](https://coreui.io/bootstrap/docs/forms/floating-labels/)
- [Bootstrap Footer](https://coreui.io/bootstrap/docs/components/footer/)
- [Bootstrap Header](https://coreui.io/bootstrap/docs/components/header/)
- [Bootstrap Image](https://coreui.io/bootstrap/docs/components/image/)
- [Bootstrap Input](https://coreui.io/bootstrap/docs/forms/input/)
- [Bootstrap Input Group](https://coreui.io/bootstrap/docs/forms/input-group/)
- [Bootstrap List Group](https://coreui.io/bootstrap/docs/components/list-group/)
- [Bootstrap Loading Button](https://coreui.io/bootstrap/docs/components/loading-button/) **PRO**
- [Bootstrap Modal](https://coreui.io/bootstrap/docs/components/modal/)
- [Bootstrap Multi Select](https://coreui.io/bootstrap/docs/forms/multi-select/) **PRO**
- [Bootstrap Navs & Tabs](https://coreui.io/bootstrap/docs/components/navs-tabs/)
- [Bootstrap Navbar](https://coreui.io/bootstrap/docs/components/navbar/)
- [Bootstrap Offcanvas](https://coreui.io/bootstrap/docs/components/offcanvas/)
- [Bootstrap Pagination](https://coreui.io/bootstrap/docs/components/pagination/)
- [Bootstrap Password Input](https://coreui.io/bootstrap/docs/forms/password-input/) **PRO**
- [Bootstrap Placeholder](https://coreui.io/bootstrap/docs/components/placeholder/)
- [Bootstrap Popover](https://coreui.io/bootstrap/docs/components/popover/)
- [Bootstrap Progress](https://coreui.io/bootstrap/docs/components/progress/)
- [Bootstrap Radio](https://coreui.io/bootstrap/docs/forms/radio/)
- [Bootstrap Range](https://coreui.io/bootstrap/docs/forms/range/)
- [Bootstrap Range Slider](https://coreui.io/bootstrap/docs/forms/range-slider/) **PRO**
- [Bootstrap Rating](https://coreui.io/bootstrap/docs/forms/rating/) **PRO**
- [Bootstrap Select](https://coreui.io/bootstrap/docs/forms/select/)
- [Bootstrap Sidebar](https://coreui.io/bootstrap/docs/components/sidebar/)
- [Bootstrap Spinner](https://coreui.io/bootstrap/docs/components/spinner/)
- [Bootstrap Stepper](https://coreui.io/bootstrap/docs/forms/stepper/) **PRO**
- [Bootstrap Switch](https://coreui.io/bootstrap/docs/forms/switch/)
- [Bootstrap Table](https://coreui.io/bootstrap/docs/content/tables/)
- [Bootstrap Textarea](https://coreui.io/bootstrap/docs/forms/textarea/)
- [Bootstrap Time Picker](https://coreui.io/bootstrap/docs/forms/time-picker/) **PRO**
- [Bootstrap Toast](https://coreui.io/bootstrap/docs/components/toast/)
- [Bootstrap Tooltip](https://coreui.io/bootstrap/docs/components/tooltip/)

## Status

[![Build Status](https://github.com/coreui/coreui/workflows/JS%20Tests/badge.svg?branch=main)](https://github.com/coreui/coreui/actions?query=workflow%3AJS+Tests+branch%3Amain)
[![npm version](https://img.shields.io/npm/v/@coreui/coreui)](https://www.npmjs.com/package/@coreui/coreui)
[![Packagist Prerelease](https://img.shields.io/packagist/vpre/coreui/coreui)](https://packagist.org/packages/coreui/coreui)
[![Coverage Status](https://img.shields.io/coveralls/github/coreui/coreui/main)](https://coveralls.io/github/coreui/coreui?branch=main)
[![CSS gzip size](https://img.badgesize.io/coreui/coreui/main/dist/css/coreui.min.css?compression=gzip&label=CSS%20gzip%20size)](https://github.com/coreui/coreui/blob/main/dist/css/coreui.min.css)
[![CSS Brotli size](https://img.badgesize.io/coreui/coreui/main/dist/css/coreui.min.css?compression=brotli&label=CSS%20Brotli%20size)](https://github.com/coreui/coreui/blob/main/dist/css/coreui.min.css)
[![JS gzip size](https://img.badgesize.io/coreui/coreui/main/dist/js/coreui.min.js?compression=gzip&label=JS%20gzip%20size)](https://github.com/coreui/coreui/blob/main/dist/js/coreui.min.js)
[![JS Brotli size](https://img.badgesize.io/coreui/coreui/main/dist/js/coreui.min.js?compression=brotli&label=JS%20Brotli%20size)](https://github.com/coreui/coreui/blob/main/dist/js/coreui.min.js)


## What's included

Within the download you'll find the following directories and files, logically grouping common assets and providing both compiled and minified variations. You'll see something like this:

```text
coreui/
├── css/
│   ├── coreui-grid.css
│   ├── coreui-grid.css.map
│   ├── coreui-grid.min.css
│   ├── coreui-grid.min.css.map
│   ├── coreui-grid.rtl.css
│   ├── coreui-grid.rtl.css.map
│   ├── coreui-grid.rtl.min.css
│   ├── coreui-grid.rtl.min.css.map
│   ├── coreui-reboot.css
│   ├── coreui-reboot.css.map
│   ├── coreui-reboot.min.css
│   ├── coreui-reboot.min.css.map
│   ├── coreui-reboot.rtl.css
│   ├── coreui-reboot.rtl.css.map
│   ├── coreui-reboot.rtl.min.css
│   ├── coreui-reboot.rtl.min.css.map
│   ├── coreui-utilities.css
│   ├── coreui-utilities.css.map
│   ├── coreui-utilities.min.css
│   ├── coreui-utilities.min.css.map
│   ├── coreui-utilities.rtl.css
│   ├── coreui-utilities.rtl.css.map
│   ├── coreui-utilities.rtl.min.css
│   ├── coreui-utilities.rtl.min.css.map
│   ├── coreui.css
│   ├── coreui.css.map
│   ├── coreui.min.css
│   ├── coreui.min.css.map
│   ├── coreui.rtl.css
│   ├── coreui.rtl.css.map
│   ├── coreui.rtl.min.css
│   └── coreui.rtl.min.css.map
└── js/
    ├── coreui.bundle.js
    ├── coreui.bundle.js.map
    ├── coreui.bundle.min.js
    ├── coreui.bundle.min.js.map
    ├── coreui.esm.js
    ├── coreui.esm.js.map
    ├── coreui.esm.min.js
    ├── coreui.esm.min.js.map
    ├── coreui.js
    ├── coreui.js.map
    ├── coreui.min.js
    └── coreui.min.js.map
```

We provide compiled CSS and JS (`coreui.*`), as well as compiled and minified CSS and JS (`coreui.min.*`). [source maps](https://developers.google.com/web/tools/chrome-devtools/javascript/source-maps) (`coreui.*.map`) are available for use with certain browsers' developer tools. Bundled JS files (`coreui.bundle.js` and minified `coreui.bundle.min.js`) include [Popper](https://popper.js.org/).


## Bugs and feature requests

Have a bug or a feature request? Please first read the [issue guidelines](https://github.com/coreui/coreui/blob/main/.github/CONTRIBUTING.md#using-the-issue-tracker) and search for existing and closed issues. If your problem or idea is not addressed yet, [please open a new issue](https://github.com/coreui/coreui/issues/new).

## Documentation

The documentation for the CoreUI & CoreUI PRO is hosted at our website [CoreUI](https://coreui.io/bootstrap/docs/getting-started/introduction/)

### Running documentation locally

1. Run `npm install` to install the Node.js dependencies, including Hugo (the site builder).
2. Run `npm run test` (or a specific npm script) to rebuild distributed CSS and JavaScript files, as well as our docs assets.
3. From the root `/coreui` directory, run `npm run docs-serve` in the command line.
4. Open `http://localhost:9001/` in your browser, and voilà.

Learn more about using Hugo by reading its [documentation](https://gohugo.io/documentation/).

## Frameworks

CoreUI supports most popular frameworks.

- [CoreUI for Angular](https://github.com/coreui/coreui-angular)
- [CoreUI for Bootstrap (Vanilla JS)](https://github.com/coreui/coreui)
- [CoreUI for React](https://github.com/coreui/coreui-react)
- [CoreUI for Vue](https://github.com/coreui/coreui-vue)

## Templates

Fully featured, out-of-the-box, templates for your application based on CoreUI.

- [Angular Admin Templates](https://coreui.io/themes-templates/admin-dashboard/angular/)
- [Bootstrap Admin Templates](https://coreui.io/themes-templates/admin-dashboard/bootstrap/)
- [Next.js Admin Templates](https://coreui.io/themes-templates/admin-dashboard/next-js/)
- [React Admin Templates](https://coreui.io/themes-templates/admin-dashboard/react/)
- [Vue Admin Templates](https://coreui.io/themes-templates/admin-dashboard/vue/)

## Contributing

Please read through our [contributing guidelines](https://github.com/coreui/coreui/blob/main/.github/CONTRIBUTING.md). Included are directions for opening issues, coding standards, and notes on development.

Editor preferences are available in the [editor config](https://github.com/coreui/coreui/blob/main/.editorconfig) for easy use in common text editors. Read more and download plugins at <https://editorconfig.org/>.

## Community

Stay up to date on the development of CoreUI and reach out to the community with these helpful resources.

- Read and subscribe to [The Official CoreUI Blog](https://coreui.io/blog).
- Follow [@core_ui on Twitter](https://x.com/core_ui).
- Discuss, ask questions, and more on [the community Discord](https://discord.gg/pQRWe5XdGm).

## Versioning

For transparency into our release cycle and in striving to maintain backward compatibility, CoreUI is maintained under [the Semantic Versioning guidelines](http://semver.org/).

See [the Releases section of our project](https://github.com/coreui/coreui/releases) for changelogs for each release version.


## Creators

**Łukasz Holeczek**

* <https://twitter.com/lukaszholeczek>
* <https://github.com/mrholek>

**Andrzej Kopański**

* <https://github.com/xidedix>

**CoreUI Team**

* <https://twitter.com/core_ui>
* <https://github.com/coreui>
* <https://github.com/orgs/coreui/people>

## Thanks
CoreUI is designed as the extension of [Bootstrap](https://getbootstrap.com). Special thanks for [Bootstrap team](https://getbootstrap.com/docs/5.0/about/team/) and [Bootstrap's contributors](https://github.com/twbs/bootstrap/graphs/contributors).

## Support CoreUI Development

CoreUI is an MIT-licensed open source project and is completely free to use. However, the amount of effort needed to maintain and develop new features for the project is not sustainable without proper financial backing. You can support development by buying the [CoreUI PRO](https://coreui.io/pricing/?framework=bootstrap&src=github-coreui) or by becoming a sponsor via [Open Collective](https://opencollective.com/coreui/).

## Copyright and license

Copyright 2025 creativeLabs Łukasz Holeczek. Code released under the [MIT License](https://github.com/coreui/coreui/blob/main/LICENSE). Docs released under [Creative Commons](https://creativecommons.org/licenses/by/3.0/).
