import Tag from '../Tag';
import { ParseOptions, TagName, TagOptions } from '../type';
/**
 * 内部含有p， 如果是第一个元素，需要最后额外加一个\n，否则开始额外加一个\n
 * 在li内部的元素需要layer，单内部元素的内部则不需要layer
 * 在li内部第一个元素，需要去除所有layer空格，但是原本如果有空行，需要保留空行
 * 在li内部的字符串，只有换行了，才需要layer
 */
declare class Li extends Tag {
    extraGap: string;
    constructor(str: string, tagName: string | undefined, options: TagOptions);
    beforeMergeSpace(content: string): string;
    __calcNextLeading__(): string;
    parseValidSubTag(subTagStr: string, subTagName: string, options: ParseOptions): [string, any];
    parseOnlyString(subTagStr: string, subTagName: TagName, options: ParseOptions): [string, any];
    beforeReturn(content: string): string;
    exec(prevGap?: string, endGap?: string): string;
}
export default Li;
