export declare type OptionsKey = 'skipTags' | 'emptyTags' | 'ignoreTags' | 'aliasTags' | 'renderCustomTags';
export declare type TagName = string | null;
export declare type Html2MdOptions = {
    skipTags?: string[];
    emptyTags?: string[];
    ignoreTags?: string[];
    aliasTags?: Record<string, string>;
    renderCustomTags?: boolean | 'SKIP' | 'EMPTY' | 'IGNORE';
    tagListener?: (tag: TagName, props: TagListenerProps) => TagListenerReturnProps;
};
export declare type TagOptions = {
    parentTag?: TagName;
    prevTagName?: TagName;
    nextTagName?: TagName;
    keepSpace?: boolean;
    prevTagStr?: string;
    nextTagStr?: string;
    isFirstSubTag?: boolean;
    calcLeading?: boolean;
    leadingSpace?: string;
    layer?: number;
    noWrap?: boolean;
    prevHasEndSpace?: boolean;
    prevHasStartSpace?: boolean;
    match?: string | null;
    indentSpace?: string;
    language?: string;
    count?: number;
    tableColumnCount?: number;
    noExtraLine?: boolean;
    inTable?: boolean;
};
export declare type SelfCloseTagOptions = {
    parentTag?: TagName;
    prevTagName?: TagName;
    nextTagName?: TagName;
    match?: string | null;
    isFirstSubTag?: boolean;
    leadingSpace?: string;
    layer?: number;
    inTable?: boolean;
};
export declare type ParseOptions = {
    parentTag?: TagName;
    prevTagName?: TagName;
    nextTagName?: TagName;
    nextTagStr?: string;
    prevTagStr?: string;
    prevHasStartSpace?: boolean;
    prevHasEndSpace?: boolean;
    leadingSpace?: string;
    layer?: number;
    keepSpace?: boolean;
    calcLeading?: boolean;
    inTable?: boolean;
};
export interface TagProps {
    tagName: TagName;
    parentTag: TagName;
    prevTagName: TagName;
    nextTagName: TagName;
    rawStr: string;
    prevTagStr: string;
    nextTagStr: string;
    isFirstSubTag: boolean;
    calcLeading: boolean;
    leadingSpace: string;
    layer: number;
    noWrap: boolean;
    hasEndSpace: boolean;
    hasStartSpace: boolean;
    prevHasEndSpace?: boolean;
    prevHasStartSpace?: boolean;
    match: string | null;
    indentSpace: string;
    language: string;
    count: number;
    tableColumnCount: number;
    noExtraLine: boolean;
    keepSpace: boolean;
    attrs: Record<string, string>;
    innerHTML: string;
    inTable: boolean;
}
export interface SelfCloseTagProps {
    tagName: TagName;
    parentTag: TagName;
    prevTagName: TagName;
    nextTagName: TagName;
    rawStr: string;
    isFirstSubTag: boolean;
    match: string | null;
    leadingSpace: string;
    layer: number;
    attrs: Record<string, string>;
    innerHTML: string;
    inTable: boolean;
}
export declare type TagListenerProps = {
    parentTag: TagName;
    prevTagName: TagName;
    nextTagName: TagName;
    isFirstSubTag: boolean;
    attrs: Record<string, string>;
    innerHTML: string;
    match: string | null;
    isSelfClosing: boolean;
    language?: string;
};
export declare type TagListenerReturnProps = {
    attrs: Record<string, string>;
    match: string | null;
    language?: string;
};
