@extends('adminlte::page')

@section('title', 'Create Communication')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Create New Communication</h3>
                    <div class="card-tools">
                        <a href="{{ route('communications.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <form action="{{ route('communications.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="subject">Subject <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('subject') is-invalid @enderror"
                                           id="subject" name="subject" value="{{ old('subject') }}" required>
                                    @error('subject')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="content">Content <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('content') is-invalid @enderror"
                                              id="content" name="content" rows="10" required>{{ old('content') }}</textarea>
                                    @error('content')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="recipient_type">Recipient Type <span class="text-danger">*</span></label>
                                    <select class="form-control @error('recipient_type') is-invalid @enderror"
                                            id="recipient_type" name="recipient_type" required>
                                        <option value="">Select Recipient Type</option>
                                        <option value="all_members" {{ old('recipient_type') === 'all_members' ? 'selected' : '' }}>
                                            All Members
                                        </option>
                                        <option value="individual" {{ old('recipient_type') === 'individual' ? 'selected' : '' }}>
                                            Individual Members
                                        </option>
                                        <option value="specific_groups" {{ old('recipient_type') === 'specific_groups' ? 'selected' : '' }}>
                                            Specific Groups
                                        </option>
                                    </select>
                                    @error('recipient_type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group" id="recipient_ids_group" style="display: none;">
                                    <label for="recipient_ids">Select Recipients</label>
                                    <select class="form-control select2" id="recipient_ids" name="recipient_ids[]" multiple>
                                        @foreach($members as $member)
                                        <option value="{{ $member->id }}"
                                                {{ in_array($member->id, old('recipient_ids', [])) ? 'selected' : '' }}>
                                            {{ $member->first_name }} {{ $member->second_name }} ({{ $member->email }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('recipient_ids')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="priority">Priority <span class="text-danger">*</span></label>
                                    <select class="form-control @error('priority') is-invalid @enderror"
                                            id="priority" name="priority" required>
                                        <option value="low" {{ old('priority') === 'low' ? 'selected' : '' }}>Low</option>
                                        <option value="normal" {{ old('priority', 'normal') === 'normal' ? 'selected' : '' }}>Normal</option>
                                        <option value="high" {{ old('priority') === 'high' ? 'selected' : '' }}>High</option>
                                        <option value="urgent" {{ old('priority') === 'urgent' ? 'selected' : '' }}>Urgent</option>
                                    </select>
                                    @error('priority')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="scheduled_at">Schedule For Later (Optional)</label>
                                    <input type="datetime-local" class="form-control @error('scheduled_at') is-invalid @enderror"
                                           id="scheduled_at" name="scheduled_at" value="{{ old('scheduled_at') }}">
                                    @error('scheduled_at')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Leave empty to send immediately</small>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input class="custom-control-input" type="checkbox" id="send_now" name="send_now" value="1"
                                               {{ old('send_now') ? 'checked' : '' }}>
                                        <label for="send_now" class="custom-control-label">
                                            Send immediately after saving
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Communication
                        </button>
                        <a href="{{ route('communications.index') }}" class="btn btn-secondary ml-2">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        placeholder: 'Select recipients',
        allowClear: true
    });

    // Show/hide recipient selection based on recipient type
    $('#recipient_type').change(function() {
        if ($(this).val() === 'individual') {
            $('#recipient_ids_group').show();
        } else {
            $('#recipient_ids_group').hide();
            $('#recipient_ids').val(null).trigger('change');
        }
    });

    // Trigger change on page load
    $('#recipient_type').trigger('change');

    // Handle send now checkbox
    $('#send_now').change(function() {
        if ($(this).is(':checked')) {
            $('#scheduled_at').prop('disabled', true).val('');
        } else {
            $('#scheduled_at').prop('disabled', false);
        }
    });

    // Set minimum datetime for scheduled_at
    const now = new Date();
    now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
    $('#scheduled_at').attr('min', now.toISOString().slice(0, 16));
});
</script>
@endsection
