@extends('adminlte::page')

@section('title', 'View Communication')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Communication Details</h3>
                    <div class="card-tools">
                        @if($communication->status === 'draft')
                        <a href="{{ route('communications.edit', $communication) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <form action="{{ route('communications.send', $communication) }}" method="POST" class="d-inline ml-2">
                            @csrf
                            @method('PATCH')
                            <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Are you sure you want to send this communication?')">
                                <i class="fas fa-paper-plane"></i> Send Now
                            </button>
                        </form>
                        @endif
                        <a href="{{ route('communications.index') }}" class="btn btn-secondary btn-sm ml-2">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-4">
                                <h4>{{ $communication->subject }}</h4>
                                <hr>
                                <div class="communication-content">
                                    {!! nl2br(e($communication->content)) !!}
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-info-circle mr-2"></i>Communication Info
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-5">Status:</dt>
                                        <dd class="col-sm-7">
                                            @if($communication->status === 'sent')
                                                <span class="badge badge-success">Sent</span>
                                            @elseif($communication->status === 'scheduled')
                                                <span class="badge badge-warning">Scheduled</span>
                                            @else
                                                <span class="badge badge-secondary">Draft</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-5">Priority:</dt>
                                        <dd class="col-sm-7">
                                            @if($communication->priority === 'urgent')
                                                <span class="badge badge-danger">Urgent</span>
                                            @elseif($communication->priority === 'high')
                                                <span class="badge badge-warning">High</span>
                                            @elseif($communication->priority === 'normal')
                                                <span class="badge badge-info">Normal</span>
                                            @else
                                                <span class="badge badge-light">Low</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-5">Recipient Type:</dt>
                                        <dd class="col-sm-7">{{ ucfirst(str_replace('_', ' ', $communication->recipient_type)) }}</dd>

                                        <dt class="col-sm-5">Created By:</dt>
                                        <dd class="col-sm-7">{{ $communication->creator->full_name ?? 'Unknown' }}</dd>

                                        <dt class="col-sm-5">Created At:</dt>
                                        <dd class="col-sm-7">{{ $communication->created_at->format('M d, Y H:i') }}</dd>

                                        @if($communication->sent_at)
                                        <dt class="col-sm-5">Sent At:</dt>
                                        <dd class="col-sm-7">{{ $communication->sent_at->format('M d, Y H:i') }}</dd>
                                        @endif

                                        @if($communication->scheduled_at)
                                        <dt class="col-sm-5">Scheduled For:</dt>
                                        <dd class="col-sm-7">{{ $communication->scheduled_at->format('M d, Y H:i') }}</dd>
                                        @endif
                                    </dl>
                                </div>
                            </div>

                            @if($communication->recipient_type === 'individual' && $communication->recipient_ids)
                            <div class="card border-success mt-3">
                                <div class="card-header bg-success">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-users mr-2"></i>Recipients ({{ count($communication->recipient_ids) }})
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled">
                                        @foreach($communication->getRecipients() as $recipient)
                                        <li class="mb-2">
                                            <i class="fas fa-user text-success mr-2"></i>
                                            {{ $recipient->first_name }} {{ $recipient->second_name }}
                                            <br>
                                            <small class="text-muted">{{ $recipient->email }}</small>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            @elseif($communication->recipient_type === 'all_members')
                            <div class="card border-primary mt-3">
                                <div class="card-header bg-primary">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-users mr-2"></i>Recipients
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0">
                                        <i class="fas fa-info-circle text-primary mr-2"></i>
                                        This communication will be sent to all members.
                                    </p>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('css')
<style>
.communication-content {
    line-height: 1.6;
    white-space: pre-wrap;
}
</style>
@endsection
