@extends('adminlte::page')

@section('title', 'Currency Details')

@section('content_header')
    <h1>Currency Details: {{ $currency->name }}</h1>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Currency Information</h3>
                    <div class="card-tools">
                        <a href="{{ route('currencies.edit', $currency) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('currencies.index') }}" class="btn btn-secondary btn-sm ml-1">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-4">Name:</dt>
                                <dd class="col-sm-8">{{ $currency->name }}</dd>

                                <dt class="col-sm-4">Code:</dt>
                                <dd class="col-sm-8">
                                    <span class="badge badge-info badge-lg">{{ $currency->code }}</span>
                                </dd>

                                <dt class="col-sm-4">Symbol:</dt>
                                <dd class="col-sm-8">
                                    <strong class="text-lg">{{ $currency->symbol }}</strong>
                                </dd>

                                <dt class="col-sm-4">Sort Order:</dt>
                                <dd class="col-sm-8">{{ $currency->sort_order }}</dd>
                            </dl>
                        </div>
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-4">Status:</dt>
                                <dd class="col-sm-8">
                                    <span class="badge badge-{{ $currency->is_active ? 'success' : 'secondary' }} badge-lg">
                                        {{ $currency->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </dd>

                                <dt class="col-sm-4">Primary:</dt>
                                <dd class="col-sm-8">
                                    @if($currency->is_primary)
                                        <span class="badge badge-warning badge-lg">
                                            <i class="fas fa-star"></i> Yes - Primary Currency
                                        </span>
                                    @else
                                        <span class="badge badge-secondary badge-lg">No</span>
                                    @endif
                                </dd>

                                <dt class="col-sm-4">Created:</dt>
                                <dd class="col-sm-8">{{ $currency->created_at->format('d M Y H:i') }}</dd>

                                <dt class="col-sm-4">Updated:</dt>
                                <dd class="col-sm-8">{{ $currency->updated_at->format('d M Y H:i') }}</dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Usage Statistics -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Usage Statistics</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <i class="fas fa-users"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Members Using</span>
                                    <span class="info-box-number">{{ $currency->is_primary ? \App\Models\Membership::count() : 0 }}</span>
                                    <div class="progress">
                                        <div class="progress-bar bg-info" style="width: {{ $currency->is_primary ? '100' : '0' }}%"></div>
                                    </div>
                                    <span class="progress-description">
                                        {{ $currency->is_primary ? 'All members' : 'Not yet implemented' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-money-bill-wave"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Loans in Currency</span>
                                    <span class="info-box-number">{{ $currency->is_primary ? \App\Models\Loan::count() : 0 }}</span>
                                    <div class="progress">
                                        <div class="progress-bar bg-success" style="width: {{ $currency->is_primary ? '100' : '0' }}%"></div>
                                    </div>
                                    <span class="progress-description">
                                        {{ $currency->is_primary ? 'All loans' : 'Not yet implemented' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-piggy-bank"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Savings Accounts</span>
                                    <span class="info-box-number">{{ $currency->is_primary ? \App\Models\Saving::count() : 0 }}</span>
                                    <div class="progress">
                                        <div class="progress-bar bg-warning" style="width: {{ $currency->is_primary ? '100' : '0' }}%"></div>
                                    </div>
                                    <span class="progress-description">
                                        {{ $currency->is_primary ? 'All savings' : 'Not yet implemented' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Quick Actions</h3>
                </div>
                <div class="card-body">
                    @if(!$currency->is_primary)
                    <form action="{{ route('currencies.set-primary', $currency) }}" method="POST" class="mb-3">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-warning btn-block">
                            <i class="fas fa-star"></i> Set as Primary Currency
                        </button>
                    </form>
                    @endif

                    <form action="{{ route('currencies.toggle-status', $currency) }}" method="POST" class="mb-3">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-{{ $currency->is_active ? 'secondary' : 'success' }} btn-block">
                            <i class="fas fa-{{ $currency->is_active ? 'pause' : 'play' }}"></i>
                            {{ $currency->is_active ? 'Deactivate' : 'Activate' }} Currency
                        </button>
                    </form>

                    @if(!$currency->is_primary)
                    <hr>
                    <form action="{{ route('currencies.destroy', $currency) }}" method="POST"
                          onsubmit="return confirm('Are you sure you want to delete this currency? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-block">
                            <i class="fas fa-trash"></i> Delete Currency
                        </button>
                    </form>
                    @endif
                </div>
            </div>

            <!-- Currency Preview -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Currency Preview</h3>
                </div>
                <div class="card-body text-center">
                    <div class="display-4 mb-3">
                        <strong>{{ $currency->symbol }}</strong>
                    </div>
                    <p class="text-muted">{{ $currency->name }} ({{ $currency->code }})</p>
                    <div class="text-lg">
                        Example: {{ $currency->formatAmount(1234.56) }}
                    </div>
                </div>
            </div>

            <!-- System Impact Warning -->
            @if($currency->is_primary)
            <div class="card mt-3 border-warning">
                <div class="card-header bg-warning">
                    <h3 class="card-title">
                        <i class="fas fa-exclamation-triangle"></i> Primary Currency
                    </h3>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                        <strong>This is the primary currency for the entire system.</strong>
                        All monetary values throughout the application use this currency as the default.
                    </p>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
