@extends('adminlte::page')

@section('title', 'Loans Management')

@section('content_header')
    <h1>Loans Management</h1>
@stop

@section('content')
<!-- Compact Statistics Cards - Dynamic Financial Data -->
<div class="row mb-3">
    <!-- Amount of Loans Issued -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Loans Issued
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh {{ number_format($loansIssued, 0) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-calendar-check mr-1"></i>
                            Principal amount lent
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Amount Expected to be Repaid -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Expected Repayment
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh {{ number_format($amountExpectedRepaid, 0) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-hand-holding-usd mr-1"></i>
                            Total expected revenue
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-calculator"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Interest/Profit -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Interest/Profit
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh {{ number_format($totalInterest, 0) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-chart-line mr-1"></i>
                            Revenue from lending
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Pending Applications -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Pending Applications
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $loans->where('status', 'pending')->count() }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock mr-1"></i>
                            Awaiting approval
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Statistics Row -->
<div class="row mb-3">
    <!-- Highest Loan Borrower -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-dark shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                            Highest Loan Borrower
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            @if($highestLoanBorrower)
                                {{ Str::limit($highestLoanBorrower->user->full_name, 15) }}
                            @else
                                No Data
                            @endif
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-trophy mr-1"></i>
                            @if($highestLoanBorrower)
                                KSh {{ number_format($highestLoanBorrower->amount, 0) }}
                            @else
                                N/A
                            @endif
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-dark text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-trophy"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Lowest Loan Borrower -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-secondary shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Lowest Loan Borrower
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            @if($lowestLoanBorrower)
                                {{ Str::limit($lowestLoanBorrower->user->full_name, 15) }}
                            @else
                                No Data
                            @endif
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-arrow-down mr-1"></i>
                            @if($lowestLoanBorrower)
                                KSh {{ number_format($lowestLoanBorrower->amount, 0) }}
                            @else
                                N/A
                            @endif
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-arrow-down"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Highest Loan Defaulter -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Highest Loan Defaulter
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            @if($highestDefaulter)
                                {{ Str::limit($highestDefaulter->user->full_name, 15) }}
                            @else
                                No Data
                            @endif
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            @if($highestDefaulter)
                                KSh {{ number_format($highestDefaulter->balance, 0) }}
                            @else
                                N/A
                            @endif
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Defaulted Amount -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Total Defaulted Amount
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh {{ number_format($totalDefaultedAmount, 0) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-times-circle mr-1"></i>
                            Outstanding balance across all loans
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-times-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Loan Applications</h3>
                    <div class="card-tools">
                        <!-- Export Buttons -->
                        <div class="btn-group mr-2">
                            <button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                    style="background: linear-gradient(45deg, #247f1b, #2d8a1f); border: 2px solid #247f1b; color: white; font-weight: 600; box-shadow: 0 0 10px rgba(36, 113, 27, 0.3); transition: all 0.3s ease;"
                                    onmouseover="this.style.background='linear-gradient(45deg, #2d8a1f, #247f1b)'; this.style.boxShadow='0 0 20px rgba(36, 113, 27, 0.6)'; this.style.transform='translateY(-1px)'"
                                    onmouseout="this.style.background='linear-gradient(45deg, #247f1b, #2d8a1f)'; this.style.boxShadow='0 0 10px rgba(36, 113, 27, 0.3)'; this.style.transform='translateY(0)'">
                                <i class="fas fa-download"></i> Export
                            </button>
                            <div class="dropdown-menu" style="border: 2px solid #247f1b; border-radius: 8px; box-shadow: 0 4px 20px rgba(36, 113, 27, 0.2);">
                                <a class="dropdown-item" href="{{ route('loans.export.pdf') }}" target="_blank"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-pdf" style="color: #ff3c30; margin-right: 8px;"></i> Export as PDF
                                </a>
                                <a class="dropdown-item" href="{{ route('loans.export.excel') }}"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-excel" style="color: #28a745; margin-right: 8px;"></i> Export as Excel
                                </a>
                                <a class="dropdown-item" href="{{ route('loans.export.csv') }}"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-csv" style="color: #17a2b8; margin-right: 8px;"></i> Export as CSV
                                </a>
                            </div>
                        </div>
                        <!-- Add Loan Button -->
                        <a href="{{ route('loans.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Loan
                        </a>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">ID</th>
                                <th class="compact-th">Member</th>
                                <th class="compact-th">Amount</th>
                                <th class="compact-th d-none d-lg-table-cell">Rate</th>
                                <th class="compact-th d-none d-md-table-cell">Term</th>
                                <th class="compact-th d-none d-lg-table-cell">Total</th>
                                <th class="compact-th d-none d-xl-table-cell">Monthly</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-md-table-cell">Applied</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($loans as $loan)
                            <tr class="compact-row">
                                <td class="compact-td">{{ $loan->id }}</td>
                                <td class="compact-td">
                                    <div class="font-weight-medium">{{ Str::limit($loan->user->full_name ?? 'N/A', 18) }}</div>
                                </td>
                                <td class="compact-td text-nowrap">KSh {{ number_format($loan->amount, 0) }}</td>
                                <td class="compact-td d-none d-lg-table-cell">{{ $loan->interest_rate }}%</td>
                                <td class="compact-td d-none d-md-table-cell">{{ $loan->term_months }}m</td>
                                <td class="compact-td d-none d-lg-table-cell text-nowrap">KSh {{ number_format($loan->total_amount, 0) }}</td>
                                <td class="compact-td d-none d-xl-table-cell text-nowrap">KSh {{ number_format($loan->monthly_payment, 0) }}</td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-{{ $loan->status === 'approved' ? 'success' : ($loan->status === 'pending' ? 'warning' : ($loan->status === 'rejected' ? 'danger' : ($loan->status === 'active' ? 'info' : 'secondary'))) }}">
                                        {{ ucfirst($loan->status) }}
                                    </span>
                                </td>
                                <td class="compact-td d-none d-md-table-cell">{{ $loan->created_at->format('d M') }}</td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="{{ route('loans.show', $loan) }}" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('loans.edit', $loan) }}" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if($loan->status === 'pending')
                                        <form action="{{ route('loans.approve', $loan) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-success btn-xs" title="Approve" onclick="return confirm('Are you sure you want to approve this loan?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('loans.reject', $loan) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-danger btn-xs" title="Reject" onclick="return confirm('Are you sure you want to reject this loan?')">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                        @endif
                                        <form action="{{ route('loans.destroy', $loan) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this loan? This action cannot be undone.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-money-bill-wave fa-3x mb-3"></i>
                                        <h5>No Loan Applications Yet</h5>
                                        <p>Start by adding your first loan application to the system.</p>
                                        <a href="{{ route('loans.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First Loan
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($loans->hasPages())
                <div class="card-footer">
                    {{ $loans->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

</div>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-danger {
    border-left: 4px solid #e74a3b !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact loans card styling */
.compact-loans-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-loans-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-loans-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-loans-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-danger {
    color: #e74a3b !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
@stop

