<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Member Activities Report - {{ $membership->membership_number }} - {{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .member-info {
            margin-bottom: 20px;
        }
        .member-info table {
            width: 100%;
            border-collapse: collapse;
        }
        .member-info th, .member-info td {
            padding: 5px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .activities-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .activities-table th, .activities-table td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .activities-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-completed {
            color: #28a745;
        }
        .status-pending {
            color: #ffc107;
        }
        .status-approved {
            color: #17a2b8;
        }
        .status-rejected {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }}</h1>
        <h2>Member Activities Report</h2>
        <p>Generated on: {{ date('d M Y H:i:s') }}</p>
    </div>

    <div class="member-info">
        <h3>Member Information</h3>
        <table>
            <tr>
                <th>Membership Number:</th>
                <td>{{ $membership->membership_number }}</td>
                <th>Full Name:</th>
                <td>{{ $membership->user->full_name }}</td>
            </tr>
            <tr>
                <th>ID Number:</th>
                <td>{{ $membership->user->id_number }}</td>
                <th>Phone:</th>
                <td>{{ $membership->user->phone_number }}</td>
            </tr>
            <tr>
                <th>Email:</th>
                <td>{{ $membership->user->email }}</td>
                <th>Branch:</th>
                <td>{{ $membership->user->branch->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Joining Date:</th>
                <td>{{ $membership->joining_date->format('d M Y') }}</td>
                <th>Status:</th>
                <td>{{ ucfirst($membership->status) }}</td>
            </tr>
        </table>
    </div>

    <div>
        <h3>Recent Activities</h3>
        <table class="activities-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Description</th>
                    <th>Module</th>
                </tr>
            </thead>
            <tbody>
                @forelse($activities as $activity)
                <tr>
                    <td>{{ date('d M Y H:i', strtotime($activity['date'])) }}</td>
                    <td>{{ $activity['type'] }}</td>
                    <td class="text-right">KSh {{ number_format($activity['amount'], 2) }}</td>
                    <td>
                        <span class="status-{{ strtolower($activity['status']) }}">
                            {{ $activity['status'] }}
                        </span>
                    </td>
                    <td>{{ $activity['description'] }}</td>
                    <td>{{ $activity['module'] }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">No activities found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top: 40px; text-align: center; font-size: 10px; color: #666;">
        <p>This report was generated automatically by the {{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} system.</p>
        <p>&copy; {{ date('Y') }} {{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }}. All rights reserved.</p>
    </div>
</body>
</html>
