@extends('adminlte::page')

@section('title', 'Edit Money Market Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Money Market Account: {{ $moneyMarketAccount->account_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('money-market-accounts.show', $moneyMarketAccount) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View
                        </a>
                        <a href="{{ route('money-market-accounts.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <form action="{{ route('money-market-accounts.update', $moneyMarketAccount) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Note:</strong> Only interest rate and notes can be modified for active accounts.
                            Principal amount, term, and dates cannot be changed once the account is created.
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account Number</label>
                                    <input type="text" class="form-control" value="{{ $moneyMarketAccount->account_number }}" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Member</label>
                                    <input type="text" class="form-control" value="{{ $moneyMarketAccount->membership->user->full_name ?? 'N/A' }} ({{ $moneyMarketAccount->membership->membership_number }})" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Principal Amount</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ \App\Helpers\CurrencyHelper::getSymbol($moneyMarketAccount->currency_code) }}</span>
                                        </div>
                                        <input type="text" class="form-control" value="{{ number_format($moneyMarketAccount->principal_amount, 2) }}" readonly>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interest_rate">Interest Rate (%) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="interest_rate" id="interest_rate" class="form-control @error('interest_rate') is-invalid @enderror"
                                               value="{{ old('interest_rate', $moneyMarketAccount->interest_rate) }}" min="0" max="50" step="0.01" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                    @error('interest_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Term</label>
                                    <input type="text" class="form-control" value="{{ $moneyMarketAccount->term_months }} months" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status</label>
                                    <input type="text" class="form-control" value="{{ ucfirst($moneyMarketAccount->status) }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Start Date</label>
                                    <input type="text" class="form-control" value="{{ $moneyMarketAccount->start_date->format('M d, Y') }}" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Maturity Date</label>
                                    <input type="text" class="form-control" value="{{ $moneyMarketAccount->maturity_date->format('M d, Y') }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">Notes</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3"
                                              placeholder="Optional notes about this investment">{{ old('notes', $moneyMarketAccount->notes) }}</textarea>
                                    @error('notes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Current Financial Summary -->
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary">
                                        <h5 class="card-title mb-0">Current Financial Summary</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <strong>Principal Amount:</strong><br>
                                                {{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code) }}
                                            </div>
                                            <div class="col-md-4">
                                                <strong>Interest Earned:</strong><br>
                                                {{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->interest_earned, $moneyMarketAccount->currency_code) }}
                                            </div>
                                            <div class="col-md-4">
                                                <strong>Total Amount:</strong><br>
                                                {{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->total_amount, $moneyMarketAccount->currency_code) }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Account
                        </button>
                        <a href="{{ route('money-market-accounts.show', $moneyMarketAccount) }}" class="btn btn-secondary ml-2">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
