@extends('adminlte::page')

@section('title', 'Money Market Account Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <!-- Account Header -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        Account: {{ $moneyMarketAccount->account_number }}
                        <span class="badge {{ $moneyMarketAccount->getStatusBadgeClass() }} ml-2">
                            {{ ucfirst($moneyMarketAccount->status) }}
                        </span>
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('money-market-accounts.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                        @if($moneyMarketAccount->status === 'active')
                        <a href="{{ route('money-market-accounts.edit', $moneyMarketAccount) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        @endif
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Account Information -->
                        <div class="col-md-6">
                            <h5>Account Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Account Number:</th>
                                    <td>{{ $moneyMarketAccount->account_number }}</td>
                                </tr>
                                <tr>
                                    <th>Member:</th>
                                    <td>{{ $moneyMarketAccount->membership->user->full_name ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Membership Number:</th>
                                    <td>{{ $moneyMarketAccount->membership->membership_number }}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <span class="badge {{ $moneyMarketAccount->getStatusBadgeClass() }}">
                                            {{ ucfirst($moneyMarketAccount->status) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Currency:</th>
                                    <td>{{ $moneyMarketAccount->currency_code }}</td>
                                </tr>
                            </table>
                        </div>

                        <!-- Investment Details -->
                        <div class="col-md-6">
                            <h5>Investment Details</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Principal Amount:</th>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code) }}</td>
                                </tr>
                                <tr>
                                    <th>Interest Rate:</th>
                                    <td>{{ number_format($moneyMarketAccount->interest_rate, 2) }}% per annum</td>
                                </tr>
                                <tr>
                                    <th>Term:</th>
                                    <td>{{ $moneyMarketAccount->term_months }} months</td>
                                </tr>
                                <tr>
                                    <th>Start Date:</th>
                                    <td>{{ $moneyMarketAccount->start_date->format('M d, Y') }}</td>
                                </tr>
                                <tr>
                                    <th>Maturity Date:</th>
                                    <td>{{ $moneyMarketAccount->maturity_date->format('M d, Y') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <!-- Financial Summary -->
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Financial Summary</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Principal Amount</span>
                                            <span class="info-box-number">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code) }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-success">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Interest Earned</span>
                                            <span class="info-box-number">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->interest_earned, $moneyMarketAccount->currency_code) }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-primary">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Amount</span>
                                            <span class="info-box-number">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->total_amount, $moneyMarketAccount->currency_code) }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-warning">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Days to Maturity</span>
                                            <span class="info-box-number">{{ max(0, $moneyMarketAccount->daysUntilMaturity()) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($moneyMarketAccount->notes)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Notes</h5>
                            <p>{{ $moneyMarketAccount->notes }}</p>
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    @if($moneyMarketAccount->status === 'active' || $moneyMarketAccount->status === 'matured')
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Actions</h5>
                            <div class="btn-group">
                                @if($moneyMarketAccount->status === 'active' || $moneyMarketAccount->status === 'matured')
                                <button type="button" class="btn btn-danger" onclick="withdrawAccount()">
                                    <i class="fas fa-money-bill-wave"></i> Withdraw Funds
                                </button>
                                @endif

                                @if($moneyMarketAccount->isMatured() && $moneyMarketAccount->status === 'active')
                                <button type="button" class="btn btn-success ml-2" onclick="markAsMatured()">
                                    <i class="fas fa-check"></i> Mark as Matured
                                </button>
                                @endif

                                <button type="button" class="btn btn-info ml-2" onclick="updateInterest()">
                                    <i class="fas fa-calculator"></i> Update Interest
                                </button>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Withdrawal History -->
                    @if($moneyMarketAccount->withdrawn_at)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Withdrawal Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">Withdrawal Date:</th>
                                    <td>{{ $moneyMarketAccount->withdrawn_at->format('M d, Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>Withdrawal Amount:</th>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->withdrawal_amount, $moneyMarketAccount->currency_code) }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
function withdrawAccount() {
    const amount = prompt('Enter withdrawal amount (leave empty for full amount):', '{{ $moneyMarketAccount->total_amount }}');
    if (amount !== null) {
        $.post('{{ route("money-market-accounts.withdraw", $moneyMarketAccount) }}', {
            _token: '{{ csrf_token() }}',
            withdrawal_amount: amount || '{{ $moneyMarketAccount->total_amount }}'
        }).done(function(response) {
            location.reload();
        }).fail(function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Withdrawal failed'));
        });
    }
}

function markAsMatured() {
    if (confirm('Mark this account as matured?')) {
        $.post('{{ route("money-market-accounts.mark-matured", $moneyMarketAccount) }}', {
            _token: '{{ csrf_token() }}'
        }).done(function(response) {
            location.reload();
        });
    }
}

function updateInterest() {
    if (confirm('Update interest earned for this account?')) {
        $.post('{{ route("money-market-accounts.update-interest") }}', {
            _token: '{{ csrf_token() }}'
        }).done(function(response) {
            location.reload();
        });
    }
}
</script>
@endsection
