@extends('adminlte::page')

@section('title', 'Add M-Pesa Credentials')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa API Configuration</h3>
                    <div class="card-tools">
                        <a href="{{ route('mpesa-credentials.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Credentials
                        </a>
                    </div>
                </div>
                <form action="{{ route('mpesa-credentials.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Security Notice</h5>
                            <p>Keep your M-Pesa credentials secure. Never share them publicly or commit them to version control.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="consumer_key">Consumer Key <span class="text-danger">*</span></label>
                                    <input type="text" name="consumer_key" id="consumer_key"
                                           class="form-control @error('consumer_key') is-invalid @enderror"
                                           value="{{ old('consumer_key') }}" required>
                                    <small class="form-text text-muted">From Safaricom Developer Portal</small>
                                    @error('consumer_key')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="consumer_secret">Consumer Secret <span class="text-danger">*</span></label>
                                    <input type="password" name="consumer_secret" id="consumer_secret"
                                           class="form-control @error('consumer_secret') is-invalid @enderror"
                                           value="{{ old('consumer_secret') }}" required>
                                    <small class="form-text text-muted">From Safaricom Developer Portal</small>
                                    @error('consumer_secret')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="shortcode">Shortcode <span class="text-danger">*</span></label>
                                    <input type="text" name="shortcode" id="shortcode"
                                           class="form-control @error('shortcode') is-invalid @enderror"
                                           value="{{ old('shortcode') }}" required>
                                    <small class="form-text text-muted">Your M-Pesa business shortcode</small>
                                    @error('shortcode')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="passkey">Passkey <span class="text-danger">*</span></label>
                                    <input type="text" name="passkey" id="passkey"
                                           class="form-control @error('passkey') is-invalid @enderror"
                                           value="{{ old('passkey') }}" required>
                                    <small class="form-text text-muted">Your M-Pesa passkey</small>
                                    @error('passkey')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="environment">Environment <span class="text-danger">*</span></label>
                                    <select name="environment" id="environment" class="form-control @error('environment') is-invalid @enderror" required>
                                        <option value="sandbox" {{ old('environment', 'sandbox') == 'sandbox' ? 'selected' : '' }}>Sandbox (Testing)</option>
                                        <option value="production" {{ old('environment') == 'production' ? 'selected' : '' }}>Production (Live)</option>
                                    </select>
                                    <small class="form-text text-muted">Use sandbox for testing, production for live payments</small>
                                    @error('environment')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" name="is_active" id="is_active"
                                               class="custom-control-input" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">Active</label>
                                    </div>
                                    <small class="form-text text-muted">Only one set of credentials can be active at a time</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="alert alert-info">
                                <h6><i class="icon fas fa-info-circle"></i> Environment Information</h6>
                                <div id="sandbox-info" style="{{ old('environment', 'sandbox') == 'sandbox' ? '' : 'display: none;' }}">
                                    <strong>Sandbox (Testing) Environment:</strong>
                                    <ul class="mb-0 mt-1">
                                        <li>Use for development and testing</li>
                                        <li>No real money transactions</li>
                                        <li>Test credentials from developer portal</li>
                                    </ul>
                                </div>
                                <div id="production-info" style="{{ old('environment') == 'production' ? '' : 'display: none;' }}">
                                    <strong>Production (Live) Environment:</strong>
                                    <ul class="mb-0 mt-1">
                                        <li>Use for real customer payments</li>
                                        <li>Real money transactions</li>
                                        <li>Production credentials required</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save M-Pesa Credentials
                        </button>
                        <a href="{{ route('mpesa-credentials.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const environmentSelect = document.getElementById('environment');
    const sandboxInfo = document.getElementById('sandbox-info');
    const productionInfo = document.getElementById('production-info');

    environmentSelect.addEventListener('change', function() {
        if (this.value === 'sandbox') {
            sandboxInfo.style.display = 'block';
            productionInfo.style.display = 'none';
        } else {
            sandboxInfo.style.display = 'none';
            productionInfo.style.display = 'block';
        }
    });
});
</script>
@stop

