@extends('adminlte::page')

@section('title', 'Savings Performance Report')

@section('content')
<div class="container-fluid">
    <!-- Export Options -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="btn-group">
                <a href="{{ route('reports.savingsPerformance', ['export' => 'pdf', 'format' => 'pdf']) }}"
                   class="btn btn-danger" target="_blank">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="{{ route('reports.savingsPerformance', ['export' => 'excel', 'format' => 'excel']) }}"
                   class="btn btn-success" target="_blank">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
        </div>
    </div>

    <!-- Savings Overview -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-piggy-bank mr-2"></i>Savings Portfolio Overview
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Accounts</span>
                                    <span class="info-box-number">{{ number_format($data['growth_metrics']['total_accounts']) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <div class="info-box-content">
                                    <span class="info-box-text">Active Accounts</span>
                                    <span class="info-box-number">{{ number_format($data['growth_metrics']['active_accounts']) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Balance</span>
                                    <span class="info-box-number">KSh {{ number_format($data['growth_metrics']['total_balance'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-primary">
                                <div class="info-box-content">
                                    <span class="info-box-text">Average Balance</span>
                                    <span class="info-box-number">KSh {{ number_format($data['growth_metrics']['average_balance'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Activity -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-calendar-alt mr-2"></i>Monthly Activity ({{ now()->format('M Y') }})
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Monthly Deposits</span>
                                    <span class="info-box-number">KSh {{ number_format($data['growth_metrics']['monthly_deposits'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box bg-danger">
                                <div class="info-box-content">
                                    <span class="info-box-text">Monthly Withdrawals</span>
                                    <span class="info-box-number">KSh {{ number_format($data['growth_metrics']['monthly_withdrawals'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Net Monthly Flow -->
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card card-outline card-primary">
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-12">
                                            <h4 class="{{ ($data['growth_metrics']['monthly_deposits'] - $data['growth_metrics']['monthly_withdrawals']) >= 0 ? 'text-success' : 'text-danger' }}">
                                                <i class="fas fa-balance-scale mr-2"></i>
                                                Net Monthly Flow: KSh {{ number_format($data['growth_metrics']['monthly_deposits'] - $data['growth_metrics']['monthly_withdrawals'], 2) }}
                                            </h4>
                                            <div class="progress mt-3">
                                                @php
                                                    $maxValue = max(abs($data['growth_metrics']['monthly_deposits']), abs($data['growth_metrics']['monthly_withdrawals']));
                                                    $depositPercent = $maxValue > 0 ? ($data['growth_metrics']['monthly_deposits'] / $maxValue) * 100 : 0;
                                                    $withdrawalPercent = $maxValue > 0 ? ($data['growth_metrics']['monthly_withdrawals'] / $maxValue) * 100 : 0;
                                                @endphp
                                                <div class="progress-bar bg-success" role="progressbar"
                                                     style="width: {{ $depositPercent }}%"
                                                     title="Deposits: KSh {{ number_format($data['growth_metrics']['monthly_deposits'], 2) }}">
                                                    Deposits
                                                </div>
                                                <div class="progress-bar bg-danger" role="progressbar"
                                                     style="width: {{ $withdrawalPercent }}%"
                                                     title="Withdrawals: KSh {{ number_format($data['growth_metrics']['monthly_withdrawals'], 2) }}">
                                                    Withdrawals
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Savings by Type and Status -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-tags mr-2"></i>Savings by Type
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Balance</th>
                                    <th class="text-right">Average Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data['by_type'] as $type => $stats)
                                <tr>
                                    <td>{{ ucwords(str_replace('_', ' ', $type)) }}</td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_balance'], 2) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['average_balance'], 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-toggle-on mr-2"></i>Savings by Status
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data['by_status'] as $status => $stats)
                                <tr>
                                    <td>
                                        <span class="badge badge-{{ $status === 'active' ? 'success' : 'secondary' }}">
                                            {{ ucfirst($status) }}
                                        </span>
                                    </td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_balance'], 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Member Balance Distribution -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar mr-2"></i>Member Balance Distribution
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Balance Range</th>
                                    <th class="text-center">Number of Members</th>
                                    <th class="text-right">Total Balance</th>
                                    <th class="text-center">Percentage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalMembers = collect($data['member_distribution'])->sum('count');
                                    $totalBalance = collect($data['member_distribution'])->sum('total_balance');
                                @endphp
                                @foreach($data['member_distribution'] as $range => $stats)
                                <tr>
                                    <td>{{ $range }}</td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_balance'], 2) }}</td>
                                    <td class="text-center">
                                        <div class="progress" style="height: 20px;">
                                            @php
                                                $percentage = $totalMembers > 0 ? ($stats['count'] / $totalMembers) * 100 : 0;
                                            @endphp
                                            <div class="progress-bar bg-primary" role="progressbar"
                                                 style="width: {{ $percentage }}%"
                                                 aria-valuenow="{{ $percentage }}"
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($percentage, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Savings Health Indicators -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-heartbeat mr-2"></i>Savings Health Indicators
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ number_format(($data['growth_metrics']['active_accounts'] / max($data['growth_metrics']['total_accounts'], 1)) * 100, 1) }}%</h3>
                                    <p>Account Activity Rate</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-user-check"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>
                                        @php
                                            $avgMonthlyActivity = ($data['growth_metrics']['monthly_deposits'] + $data['growth_metrics']['monthly_withdrawals']) / max($data['growth_metrics']['active_accounts'], 1);
                                        @endphp
                                        KSh {{ number_format($avgMonthlyActivity, 2) }}
                                    </h3>
                                    <p>Avg Monthly Activity per Account</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>
                                        @php
                                            $savingsRatio = $data['growth_metrics']['total_accounts'] > 0
                                                ? ($data['growth_metrics']['active_accounts'] / $data['growth_metrics']['total_accounts']) * 100
                                                : 0;
                                        @endphp
                                        {{ number_format($savingsRatio, 1) }}%
                                    </h3>
                                    <p>Savings Participation Rate</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-users"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>
                                        @php
                                            $growthRate = $data['growth_metrics']['monthly_deposits'] > 0
                                                ? (($data['growth_metrics']['monthly_deposits'] - $data['growth_metrics']['monthly_withdrawals']) / $data['growth_metrics']['monthly_deposits']) * 100
                                                : 0;
                                        @endphp
                                        {{ number_format($growthRate, 1) }}%
                                    </h3>
                                    <p>Monthly Growth Rate</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-arrow-up"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

