@extends('adminlte::page')

@section('title', 'Transaction Summary Report')

@section('content')
<div class="container-fluid">
    <!-- Date Range Filter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="GET" action="{{ route('reports.transactionSummary') }}" class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Start Date</label>
                                <input type="date" name="start_date" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>End Date</label>
                                <input type="date" name="end_date" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-search"></i> Generate Report
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Export Options -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="btn-group">
                <a href="{{ route('reports.transactionSummary', array_merge(request()->query(), ['export' => 'pdf', 'format' => 'pdf'])) }}"
                   class="btn btn-danger" target="_blank">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="{{ route('reports.transactionSummary', array_merge(request()->query(), ['export' => 'excel', 'format' => 'excel'])) }}"
                   class="btn btn-success" target="_blank">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
        </div>
    </div>

    <!-- Transaction Analysis -->
    <div class="row">
        <!-- By Type -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie mr-2"></i>Transactions by Type
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Amount</th>
                                    <th class="text-right">Total Fees</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data['by_type'] as $type => $stats)
                                <tr>
                                    <td>
                                        <span class="badge badge-primary">{{ ucwords(str_replace('_', ' ', $type)) }}</span>
                                    </td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_amount'], 2) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_fees'], 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- By Status -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-tasks mr-2"></i>Transactions by Status
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data['by_status'] as $status => $stats)
                                <tr>
                                    <td>
                                        <span class="badge badge-{{ $status === 'completed' ? 'success' : ($status === 'pending' ? 'warning' : 'danger') }}">
                                            {{ ucfirst($status) }}
                                        </span>
                                    </td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_amount'], 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Methods -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-credit-card mr-2"></i>Transactions by Payment Method
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Payment Method</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Amount</th>
                                    <th class="text-center">Percentage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalAmount = collect($data['by_payment_method'])->sum('total_amount');
                                @endphp
                                @foreach($data['by_payment_method'] as $method => $stats)
                                <tr>
                                    <td>{{ $method ?: 'Not Specified' }}</td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_amount'], 2) }}</td>
                                    <td class="text-center">
                                        {{ $totalAmount > 0 ? number_format(($stats['total_amount'] / $totalAmount) * 100, 1) : 0 }}%
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Daily Transaction Trends -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-calendar-alt mr-2"></i>Daily Transaction Trends
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th class="text-center">Total Transactions</th>
                                    <th class="text-right">Total Amount</th>
                                    <th class="text-right text-success">Deposits</th>
                                    <th class="text-right text-danger">Withdrawals</th>
                                    <th class="text-right">Net Flow</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data['daily_totals'] as $date => $stats)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($date)->format('M d, Y') }}</td>
                                    <td class="text-center">{{ number_format($stats['count']) }}</td>
                                    <td class="text-right">KSh {{ number_format($stats['total_amount'], 2) }}</td>
                                    <td class="text-right text-success">KSh {{ number_format($stats['deposits'], 2) }}</td>
                                    <td class="text-right text-danger">KSh {{ number_format($stats['withdrawals'], 2) }}</td>
                                    <td class="text-right">
                                        <strong class="{{ ($stats['deposits'] - $stats['withdrawals']) >= 0 ? 'text-success' : 'text-danger' }}">
                                            KSh {{ number_format($stats['deposits'] - $stats['withdrawals'], 2) }}
                                        </strong>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="info-box bg-info">
                <div class="info-box-content">
                    <span class="info-box-text">Total Transactions</span>
                    <span class="info-box-number">{{ collect($data['by_type'])->sum('count') }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="info-box bg-success">
                <div class="info-box-content">
                    <span class="info-box-text">Total Amount</span>
                    <span class="info-box-number">KSh {{ number_format(collect($data['by_type'])->sum('total_amount'), 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="info-box bg-warning">
                <div class="info-box-content">
                    <span class="info-box-text">Total Fees</span>
                    <span class="info-box-number">KSh {{ number_format(collect($data['by_type'])->sum('total_fees'), 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="info-box bg-primary">
                <div class="info-box-content">
                    <span class="info-box-text">Net Amount</span>
                    <span class="info-box-number">
                        KSh {{ number_format(collect($data['by_type'])->sum('total_amount') - collect($data['by_type'])->sum('total_fees'), 2) }}
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

