@extends('adminlte::page')

@section('title', 'Withdraw from Savings Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">Withdraw Funds</h3>
                    <div class="card-tools">
                        <a href="{{ route('savings.show', $saving) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Account
                        </a>
                    </div>
                </div>

                <form action="{{ route('savings.withdraw.process', $saving) }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <!-- Account Information -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-primary">
                                    <div class="card-header">
                                        <h5 class="card-title">Account Information</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <dl class="row">
                                                    <dt class="col-sm-5">Member:</dt>
                                                    <dd class="col-sm-7">{{ $saving->user->full_name }}</dd>

                                                    <dt class="col-sm-5">Account Type:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="badge badge-{{ $saving->type_color }}">
                                                            {{ $saving->type_label }}
                                                        </span>
                                                    </dd>
                                                </dl>
                                            </div>
                                            <div class="col-md-6">
                                                <dl class="row">
                                                    <dt class="col-sm-5">Current Balance:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="h5 text-success">KSh {{ number_format($saving->current_balance, 2) }}</span>
                                                    </dd>

                                                    <dt class="col-sm-5">Account Status:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="badge badge-{{ $saving->status_color }}">
                                                            {{ $saving->status_label }}
                                                        </span>
                                                    </dd>
                                                </dl>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($saving->current_balance <= 0)
                        <div class="alert alert-danger">
                            <h5><i class="icon fas fa-ban"></i> Insufficient Funds!</h5>
                            This savings account has no funds available for withdrawal.
                        </div>
                        @else
                        <!-- Withdrawal Form -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Withdrawal Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control form-control-lg @error('amount') is-invalid @enderror"
                                           value="{{ old('amount') }}" min="1" max="{{ $saving->current_balance }}" step="0.01" required>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    <small class="form-text text-muted">Maximum withdrawal: KSh {{ number_format($saving->current_balance, 2) }}</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">Transaction Notes</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                                              rows="3" placeholder="Optional notes about this withdrawal">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Preview -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-warning">
                                    <div class="card-header">
                                        <h5 class="card-title">Transaction Preview</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Current Balance</span>
                                                        <span class="info-box-number" id="current-balance">KSh {{ number_format($saving->current_balance, 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-danger">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Withdrawal Amount</span>
                                                        <span class="info-box-number" id="withdrawal-amount">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-primary">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Remaining Balance</span>
                                                        <span class="info-box-number" id="remaining-balance">KSh {{ number_format($saving->current_balance, 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    @if($saving->current_balance > 0)
                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning btn-lg">
                            <i class="fas fa-minus-circle"></i> Process Withdrawal
                        </button>
                        <a href="{{ route('savings.show', $saving) }}" class="btn btn-secondary btn-lg">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                    @endif
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Quick Stats -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Account Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="description-block">
                                <span class="description-header">KSh {{ number_format($saving->current_balance, 2) }}</span>
                                <span class="description-text">CURRENT BALANCE</span>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-6">
                            <div class="description-block">
                                <span class="description-header">{{ $saving->transactions()->where('type', 'deposit')->count() }}</span>
                                <span class="description-text">DEPOSITS</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="description-block">
                                <span class="description-header">{{ $saving->transactions()->where('type', 'withdrawal')->count() }}</span>
                                <span class="description-text">WITHDRAWALS</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Transactions</h3>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @forelse($saving->transactions()->limit(5)->get() as $transaction)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <span class="badge badge-{{ $transaction->type_color }}">{{ $transaction->type_label }}</span>
                                    <small class="text-muted">{{ $transaction->transaction_date->format('d M Y') }}</small>
                                </div>
                                <div class="text-right">
                                    <span class="font-weight-bold {{ $transaction->type === 'deposit' ? 'text-success' : 'text-danger' }}">
                                        {{ $transaction->formatted_amount }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="list-group-item text-center text-muted">
                            <small>No transactions yet</small>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@push('js')
@if($saving->current_balance > 0)
<script>
$(document).ready(function() {
    function updatePreview() {
        var currentBalance = {{ $saving->current_balance }};
        var withdrawalAmount = parseFloat($('#amount').val()) || 0;
        var remainingBalance = currentBalance - withdrawalAmount;

        $('#withdrawal-amount').text('KSh ' + withdrawalAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#remaining-balance').text('KSh ' + remainingBalance.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $('#amount').on('input', updatePreview);
    updatePreview(); // Initial calculation
});
</script>
@endif
@endpush

