@extends('adminlte::page')

@section('title', 'Edit Share Purchase')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Update Share Purchase Information</h3>
                    <div class="card-tools">
                        <a href="{{ route('shares.show', $share) }}" class="btn btn-outline-info btn-sm">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="{{ route('shares.index') }}" class="btn btn-outline-secondary btn-sm ml-1">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
                <form action="{{ route('shares.update', $share) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_id">Member <span class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id"
                                            class="form-control @error('user_id') is-invalid @enderror" required>
                                        <option value="">Select a member</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" {{ old('user_id', $share->user_id) == $user->id ? 'selected' : '' }}>
                                                {{ $user->full_name }} ({{ $user->membership_number ?? 'No ID' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">Select the member who purchased shares</small>
                                    @error('user_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="number_of_shares">Number of Shares <span class="text-danger">*</span></label>
                                    <input type="number" name="number_of_shares" id="number_of_shares"
                                           class="form-control @error('number_of_shares') is-invalid @enderror"
                                           value="{{ old('number_of_shares', $share->number_of_shares) }}" min="1" required>
                                    <small class="form-text text-muted">Enter the number of shares purchased</small>
                                    @error('number_of_shares')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="share_value">Share Value (KES) <span class="text-danger">*</span></label>
                                    <input type="number" name="share_value" id="share_value" step="0.01"
                                           class="form-control @error('share_value') is-invalid @enderror"
                                           value="{{ old('share_value', $share->share_value) }}" min="0.01" required>
                                    <small class="form-text text-muted">Value per share in Kenyan Shillings</small>
                                    @error('share_value')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_value">Total Value (KES)</label>
                                    <input type="number" name="total_value" id="total_value" step="0.01"
                                           class="form-control" value="{{ old('total_value', $share->total_value) }}" readonly>
                                    <small class="form-text text-muted">Automatically calculated (Shares × Value)</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="purchase_date">Purchase Date <span class="text-danger">*</span></label>
                                    <input type="date" name="purchase_date" id="purchase_date"
                                           class="form-control @error('purchase_date') is-invalid @enderror"
                                           value="{{ old('purchase_date', $share->purchase_date->format('Y-m-d')) }}" required>
                                    <small class="form-text text-muted">Date when the shares were purchased</small>
                                    @error('purchase_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                                      rows="4" placeholder="Additional notes about this share purchase...">{{ old('notes', $share->notes) }}</textarea>
                            <small class="form-text text-muted">Optional notes about the share purchase</small>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-save"></i> Update Share Purchase
                        </button>
                        <a href="{{ route('shares.show', $share) }}" class="btn btn-outline-secondary btn-sm ml-2">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('js')
<script>
$(document).ready(function() {
    // Auto-calculate total value when number of shares or share value changes
    function calculateTotal() {
        var shares = parseFloat($('#number_of_shares').val()) || 0;
        var value = parseFloat($('#share_value').val()) || 0;
        var total = shares * value;
        $('#total_value').val(total.toFixed(2));
    }

    $('#number_of_shares, #share_value').on('input', calculateTotal);

    // Initial calculation
    calculateTotal();
});
</script>
@endpush
@stop
