@extends('adminlte::page')

@section('title', 'Share Purchase Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Share Purchase #{{ $share->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('shares.edit', $share) }}" class="btn btn-outline-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="{{ route('shares.index') }}" class="btn btn-outline-secondary btn-sm ml-1">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-bordered">
                                <tr>
                                    <th class="bg-light" style="width: 200px;">Share ID</th>
                                    <td>{{ $share->id }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Member</th>
                                    <td>
                                        <strong>{{ $share->user->full_name ?? 'N/A' }}</strong>
                                        @if($share->user->membership_number)
                                            <br><small class="text-muted">Membership #: {{ $share->user->membership_number }}</small>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Number of Shares</th>
                                    <td>
                                        <span class="badge badge-primary badge-lg">
                                            {{ number_format($share->number_of_shares) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Share Value</th>
                                    <td>{{ $share->formatted_share_value }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Total Value</th>
                                    <td>
                                        <strong class="text-success">{{ $share->formatted_total_value }}</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Purchase Date</th>
                                    <td>{{ $share->purchase_date_formatted }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Notes</th>
                                    <td>{{ $share->notes ?? 'No notes provided' }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Created</th>
                                    <td>{{ $share->created_at->format('d M Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Last Updated</th>
                                    <td>{{ $share->updated_at->format('d M Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-share-alt"></i> Share Summary
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <h2 class="text-primary">{{ number_format($share->number_of_shares) }}</h2>
                                        <p class="text-muted mb-0">Shares purchased</p>
                                    </div>
                                    <hr>
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <h4 class="text-success mb-0">{{ $share->formatted_share_value }}</h4>
                                            <small class="text-muted">Per share</small>
                                        </div>
                                        <div class="col-6">
                                            <h4 class="text-info mb-0">{{ $share->formatted_total_value }}</h4>
                                            <small class="text-muted">Total value</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card border-success mt-3">
                                <div class="card-header bg-success text-white">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-info-circle"></i> Purchase Status
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled small mb-0">
                                        <li><i class="fas fa-check-circle text-success"></i> Purchase completed</li>
                                        <li><i class="fas fa-calendar-alt text-success"></i> Date: {{ $share->purchase_date_formatted }}</li>
                                        <li><i class="fas fa-user text-success"></i> Member: {{ $share->user->full_name ?? 'N/A' }}</li>
                                        @if($share->notes)
                                        <li><i class="fas fa-sticky-note text-success"></i> Notes available</li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Transaction Code:</strong> SHR{{ str_pad($share->id, 4, '0', STR_PAD_LEFT) }}
                            </small>
                        </div>
                        <div class="col-md-6 text-right">
                            <form action="{{ route('shares.destroy', $share) }}" method="POST" class="d-inline"
                                  onsubmit="return confirm('Are you sure you want to delete this share purchase?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
