@extends('adminlte::page')

@section('title', 'System Configuration')

@section('content')
<style>
/* Custom System Settings Tab Styling */
.nav-tabs .nav-link {
    color: #247f1b !important; /* Primary green color */
    border-color: #247f1b #247f1b #dee2e6 !important;
    background-color: transparent !important;
    font-weight: 500;
    transition: all 0.3s ease;
}

.nav-tabs .nav-link:hover {
    color: #1e6b16 !important; /* Darker green on hover */
    background-color: rgba(36, 127, 27, 0.1) !important;
    border-color: #247f1b !important;
}

.nav-tabs .nav-link.active {
    color: #dc3545 !important; /* Red color for active tab */
    background-color: rgba(220, 53, 69, 0.1) !important;
    border-color: #dc3545 #dc3545 #fff !important;
    border-bottom-color: #fff !important;
}

.nav-tabs .nav-link.active:hover {
    color: #c82333 !important; /* Darker red on hover for active tab */
}
</style>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <form action="{{ route('system-settings.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Configure System Settings</h3>
                        <div class="card-tools">
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-save"></i> Save
                            </button>
                        </div>
                    </div>

                    <div class="card-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                            @foreach($categories as $categoryKey => $category)
                            <li class="nav-item">
                                <a class="nav-link {{ $loop->first ? 'active' : '' }}" id="{{ $categoryKey }}-tab" data-toggle="tab" href="#{{ $categoryKey }}" role="tab">
                                    <i class="{{ $category['icon'] }}"></i> {{ $category['title'] }}
                                </a>
                            </li>
                            @endforeach
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content mt-3" id="settingsTabContent">
                            @foreach($categories as $categoryKey => $category)
                            <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" id="{{ $categoryKey }}" role="tabpanel">
                                @if($categoryKey === 'database')
                                    <!-- Database Management Section -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5 class="card-title mb-0">
                                                        <i class="fas fa-database mr-2"></i>Database Backup & Restore
                                                    </h5>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <!-- Export Section -->
                                                        <div class="col-md-6">
                                                            <div class="border rounded p-4 text-center">
                                                                <i class="fas fa-download fa-3x text-success mb-3"></i>
                                                                <h5>Export Database</h5>
                                                                <p class="text-muted">Create a backup of your entire database including all tables and data.</p>
                                                                <a href="{{ route('system-settings.export-database') }}" class="btn btn-success btn-lg">
                                                                    <i class="fas fa-download mr-2"></i>Export Database
                                                                </a>
                                                                <div class="mt-3">
                                                                    <small class="text-muted">
                                                                        <i class="fas fa-info-circle mr-1"></i>
                                                                        Backup files are automatically deleted after download for security.
                                                                    </small>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Import Section -->
                                                        <div class="col-md-6">
                                                            <div class="border rounded p-4 text-center">
                                                                <i class="fas fa-upload fa-3x text-warning mb-3"></i>
                                                                <h5>Restore Database</h5>
                                                                <p class="text-muted">Restore your database from a previously exported backup file.</p>
                                                                <form action="{{ route('system-settings.import-database') }}" method="POST" enctype="multipart/form-data">
                                                                    @csrf
                                                                    <div class="form-group mb-3">
                                                                        <label for="backup_file" class="form-label">Select Backup File</label>
                                                                        <input type="file" class="form-control @error('backup_file') is-invalid @enderror"
                                                                               id="backup_file" name="backup_file" accept=".sql" required>
                                                                        <div class="form-text">Only .sql files are accepted</div>
                                                                        @error('backup_file')
                                                                            <div class="invalid-feedback">{{ $message }}</div>
                                                                        @enderror
                                                                    </div>
                                                                    <button type="submit" class="btn btn-warning btn-lg"
                                                                            onclick="return confirm('Are you sure you want to restore the database? This will overwrite all current data.')">
                                                                        <i class="fas fa-upload mr-2"></i>Restore Database
                                                                    </button>
                                                                    <div class="mt-3">
                                                                        <small class="text-danger">
                                                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                                                            Warning: This action cannot be undone. Make sure you have a recent backup.
                                                                        </small>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Backup Information -->
                                                    <div class="row mt-4">
                                                        <div class="col-md-12">
                                                            <div class="alert alert-info">
                                                                <h6><i class="fas fa-info-circle mr-2"></i>Backup Information</h6>
                                                                <ul class="mb-0">
                                                                    <li>Regular backups are essential for data safety</li>
                                                                    <li>Backup files contain all your database tables and data</li>
                                                                    <li>Store backup files securely in multiple locations</li>
                                                                    <li>Test restore functionality periodically</li>
                                                                    <li>Backup before making major system changes</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="row">
                                        @foreach($category['settings'] as $settingKey => $settingConfig)
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="{{ $settingKey }}">
                                                    {{ $settingConfig['label'] }}
                                                    @if(isset($settingConfig['description']) && $settingConfig['description'])
                                                    <small class="form-text text-muted">{{ $settingConfig['description'] }}</small>
                                                    @endif
                                                </label>

                                                @if($settingConfig['type'] === 'file')
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="{{ $settingKey }}" name="files[{{ $settingKey }}]" accept="image/*">
                                                            <label class="custom-file-label" for="{{ $settingKey }}">Choose file</label>
                                                        </div>
                                                    </div>
                                                    @if($settings->get($categoryKey, collect())->where('key', $settingKey)->first())
                                                        <div class="mt-2">
                                                            <small class="text-muted">Current: {{ $settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value }}</small>
                                                        </div>
                                                    @endif
                                                @elseif($settingConfig['type'] === 'select')
                                                    <select class="form-control" id="{{ $settingKey }}" name="settings[{{ $settingKey }}]">
                                                        @if(isset($settingConfig['options']) && is_array($settingConfig['options']))
                                                            @foreach($settingConfig['options'] as $optionValue => $optionLabel)
                                                                <option value="{{ $optionValue }}"
                                                                        {{ ($settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? '') == $optionValue ? 'selected' : '' }}>
                                                                    {{ $optionLabel }}
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                @elseif($settingConfig['type'] === 'text')
                                                    <textarea class="form-control" id="{{ $settingKey }}" name="settings[{{ $settingKey }}]" rows="3"
                                                              placeholder="{{ $settingConfig['default'] ?? '' }}">{{ $settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? '' }}</textarea>
                                                @else
                                                    <input type="{{ $settingConfig['type'] === 'number' ? 'number' : 'text' }}"
                                                           class="form-control" id="{{ $settingKey }}" name="settings[{{ $settingKey }}]"
                                                           value="{{ $settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? '' }}"
                                                           placeholder="{{ $settingConfig['default'] ?? '' }}">
                                                @endif
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="card-footer">
                        @if($categories && !empty($categories))
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-save"></i> Save
                            </button>
                        @endif
                        <a href="{{ route('home') }}" class="btn btn-outline-secondary btn-sm ml-2">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>


</div>
@stop

@section('plugins.Datatables', true)

@section('js')
<script>
$(document).ready(function() {
    // File input label update
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });

    // Form validation
    $('form').on('submit', function(e) {
        // Add any custom validation here if needed
        return true;
    });
});
</script>
@stop

