@extends('adminlte::page')

@section('title', 'Edit Transaction')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">Edit Transaction Details</h3>
                </div>

                <form action="{{ route('transactions.update', $transaction) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_id">Member <span class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id" class="form-control @error('user_id') is-invalid @enderror" required>
                                        <option value="">Select Member</option>
                                        @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id', $transaction->user_id) == $user->id ? 'selected' : '' }}>
                                            {{ $user->full_name }} ({{ $user->id_number }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Transaction Type <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" required>
                                        <option value="">Select Type</option>
                                        @foreach($transactionTypes as $key => $label)
                                        <option value="{{ $key }}" {{ old('type', $transaction->type) == $key ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="amount">Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror"
                                           value="{{ old('amount', $transaction->amount) }}" min="0.01" step="0.01" required>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="fee_amount">Fee Amount (KSh)</label>
                                    <input type="number" name="fee_amount" id="fee_amount" class="form-control @error('fee_amount') is-invalid @enderror"
                                           value="{{ old('fee_amount', $transaction->fee_amount) }}" min="0" step="0.01">
                                    @error('fee_amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_amount">Tax Amount (KSh)</label>
                                    <input type="number" name="tax_amount" id="tax_amount" class="form-control @error('tax_amount') is-invalid @enderror"
                                           value="{{ old('tax_amount', $transaction->tax_amount) }}" min="0" step="0.01">
                                    @error('tax_amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="from_user_id">From Member</label>
                                    <select name="from_user_id" id="from_user_id" class="form-control @error('from_user_id') is-invalid @enderror">
                                        <option value="">Select Member (Optional)</option>
                                        @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('from_user_id', $transaction->from_user_id) == $user->id ? 'selected' : '' }}>
                                            {{ $user->full_name }} ({{ $user->id_number }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('from_user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="to_user_id">To Member</label>
                                    <select name="to_user_id" id="to_user_id" class="form-control @error('to_user_id') is-invalid @enderror">
                                        <option value="">Select Member (Optional)</option>
                                        @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('to_user_id', $transaction->to_user_id) == $user->id ? 'selected' : '' }}>
                                            {{ $user->full_name }} ({{ $user->id_number }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('to_user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="payment_method">Payment Method</label>
                                    <select name="payment_method" id="payment_method" class="form-control @error('payment_method') is-invalid @enderror">
                                        <option value="">Select Method</option>
                                        <option value="M-Pesa" {{ old('payment_method', $transaction->payment_method) == 'M-Pesa' ? 'selected' : '' }}>M-Pesa</option>
                                        <option value="Bank Transfer" {{ old('payment_method', $transaction->payment_method) == 'Bank Transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                        <option value="Cash" {{ old('payment_method', $transaction->payment_method) == 'Cash' ? 'selected' : '' }}>Cash</option>
                                        <option value="Cheque" {{ old('payment_method', $transaction->payment_method) == 'Cheque' ? 'selected' : '' }}>Cheque</option>
                                        <option value="Other" {{ old('payment_method', $transaction->payment_method) == 'Other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    @error('payment_method')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="mpesa_transaction_id">M-Pesa Transaction ID</label>
                                    <input type="text" name="mpesa_transaction_id" id="mpesa_transaction_id"
                                           class="form-control @error('mpesa_transaction_id') is-invalid @enderror"
                                           value="{{ old('mpesa_transaction_id', $transaction->mpesa_transaction_id) }}">
                                    @error('mpesa_transaction_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="pending" {{ old('status', $transaction->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="completed" {{ old('status', $transaction->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                        <option value="failed" {{ old('status', $transaction->status) == 'failed' ? 'selected' : '' }}>Failed</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror"
                                              rows="3" placeholder="Brief description of the transaction">{{ old('description', $transaction->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">Internal Notes</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                                              rows="3" placeholder="Internal notes (not visible to members)">{{ old('notes', $transaction->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Transaction Summary -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-info">
                                    <div class="card-header">
                                        <h5 class="card-title">Transaction Summary</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Principal Amount</span>
                                                        <span class="info-box-number" id="summary-amount">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-warning">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Fee Amount</span>
                                                        <span class="info-box-number" id="summary-fee">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-danger">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Tax Amount</span>
                                                        <span class="info-box-number" id="summary-tax">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-success">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Total Amount</span>
                                                        <span class="info-box-number" id="summary-total">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning">Update Transaction</button>
                        <a href="{{ route('transactions.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@push('js')
<script>
$(document).ready(function() {
    function updateSummary() {
        var amount = parseFloat($('#amount').val()) || 0;
        var fee = parseFloat($('#fee_amount').val()) || 0;
        var tax = parseFloat($('#tax_amount').val()) || 0;
        var total = amount + fee + tax;

        $('#summary-amount').text('KSh ' + amount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#summary-fee').text('KSh ' + fee.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#summary-tax').text('KSh ' + tax.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#summary-total').text('KSh ' + total.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $('#amount, #fee_amount, #tax_amount').on('input', updateSummary);
    updateSummary(); // Initial calculation
});
</script>
@endpush

