@extends('adminlte::page')

@section('title', 'User Management')

@section('content_header')
    <h1>Users Management</h1>
@stop

@section('content')
<div class="container-fluid">
<!-- Compact Statistics Cards - User Management Overview -->
<div class="row mb-3">
    <!-- Total Users -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-users-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Users
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $users->total() }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-users mr-1"></i>
                            System users
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Verified Users -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-users-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Verified Users
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $users->where('email_verified_at', '!=', null)->count() }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-check mr-1"></i>
                            Email verified
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-check"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Unverified Users -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-users-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Unverified Users
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $users->where('email_verified_at', null)->count() }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-clock mr-1"></i>
                            Pending verification
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Users -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-users-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Admin Users
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $users->where('role', 'admin')->count() }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-shield mr-1"></i>
                            System administrators
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-shield"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Users Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Users</h3>
                    <div class="card-tools">
                        <div class="btn-group" role="group">
                            <a href="{{ route('users.create') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add New User
                            </a>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-download"></i> Export
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('users.export.pdf') }}" target="_blank">
                                        <i class="fas fa-file-pdf text-danger"></i> Export as PDF
                                    </a>
                                    <a class="dropdown-item" href="{{ route('users.export.excel') }}">
                                        <i class="fas fa-file-excel text-success"></i> Export as Excel
                                    </a>
                                    <a class="dropdown-item" href="{{ route('users.export.csv') }}">
                                        <i class="fas fa-file-csv text-info"></i> Export as CSV
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">Name</th>
                                <th class="compact-th d-none d-lg-table-cell">Email</th>
                                <th class="compact-th d-none d-md-table-cell">Phone</th>
                                <th class="compact-th d-none d-lg-table-cell">ID Number</th>
                                <th class="compact-th d-none d-md-table-cell">Branch</th>
                                <th class="compact-th">Role</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-md-table-cell">Joined</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($users as $user)
                            <tr class="compact-row">
                                <td class="compact-td">
                                    <div class="font-weight-medium">{{ Str::limit($user->full_name, 18) }}</div>
                                </td>
                                <td class="compact-td d-none d-lg-table-cell">{{ Str::limit($user->email, 20) }}</td>
                                <td class="compact-td d-none d-md-table-cell">{{ $user->phone_number ?? 'N/A' }}</td>
                                <td class="compact-td d-none d-lg-table-cell">{{ $user->id_number ?? 'N/A' }}</td>
                                <td class="compact-td d-none d-md-table-cell">
                                    @if($user->branch)
                                        <span class="badge badge-sm badge-info">{{ Str::limit($user->branch->name, 12) }}</span>
                                    @else
                                        <span class="text-muted">No Branch</span>
                                    @endif
                                </td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-{{ $user->role == 'admin' ? 'danger' : ($user->role == 'manager' ? 'warning' : 'success') }}">
                                        {{ ucfirst($user->role) }}
                                    </span>
                                </td>
                                <td class="compact-td">
                                    @if($user->email_verified_at)
                                        <span class="badge badge-sm badge-success">Verified</span>
                                    @else
                                        <span class="badge badge-sm badge-warning">Unverified</span>
                                    @endif
                                </td>
                                <td class="compact-td d-none d-md-table-cell">{{ $user->created_at->format('d M') }}</td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="{{ route('users.show', $user) }}" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('users.edit', $user) }}" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if($user->id != auth()->id())
                                        <form action="{{ route('users.destroy', $user) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this user? This action cannot be undone.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-users fa-3x mb-3"></i>
                                        <h5>No Users Found</h5>
                                        <p>Start by adding your first user to the system.</p>
                                        <a href="{{ route('users.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First User
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($users->hasPages())
                <div class="card-footer">
                    {{ $users->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>

</div>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-danger {
    border-left: 4px solid #e74a3b !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact users card styling */
.compact-users-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-users-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-users-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-users-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-danger {
    color: #e74a3b !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
@stop


