<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-info" style="background: linear-gradient(45deg, #17a2b8, #20c997); border: none; color: white;">
                <h4><i class="fas fa-concierge-bell"></i> Front Office Dashboard</h4>
                <p class="mb-0">Welcome back, {{ auth()->user()->full_name }}! Assist members and manage applications.</p>
            </div>
        </div>
    </div>

    <!-- Member Services Statistics -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ number_format($stats['pending_memberships']) }}</h3>
                    <p>Pending Applications</p>
                </div>
                <div class="icon">
                    <i class="fas fa-user-clock"></i>
                </div>
                <a href="{{ route('memberships.index') }}?status=pending" class="small-box-footer">
                    Process Now <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ number_format($stats['total_members']) }}</h3>
                    <p>Active Members</p>
                </div>
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
                <a href="{{ route('memberships.index') }}?status=active" class="small-box-footer">
                    View Members <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ number_format($stats['branch_members']) }}</h3>
                    <p>Your Branch Members</p>
                </div>
                <div class="icon">
                    <i class="fas fa-building"></i>
                </div>
                <a href="{{ route('users.index') }}?branch={{ auth()->user()->branch_id }}" class="small-box-footer">
                    Manage <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>{{ number_format($stats['pending_transactions']) }}</h3>
                    <p>Pending Transactions</p>
                </div>
                <div class="icon">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <a href="{{ route('transactions.index') }}?status=pending" class="small-box-footer">
                    Process <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Member Applications and Services -->
    <div class="row">
        <!-- Recent Applications -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Membership Applications</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Applicant</th>
                                    <th>Phone</th>
                                    <th>ID Number</th>
                                    <th>Status</th>
                                    <th>Applied Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stats['recent_applications'] as $application)
                                <tr>
                                    <td>{{ $application->user->full_name ?? 'N/A' }}</td>
                                    <td>{{ $application->user->phone_number ?? 'N/A' }}</td>
                                    <td>{{ $application->user->id_number ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge badge-{{ $application->status == 'active' ? 'success' : ($application->status == 'pending' ? 'warning' : 'danger') }}">
                                            {{ ucfirst($application->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $application->created_at->format('M d, Y') }}</td>
                                    <td>
                                        @if($application->status == 'pending')
                                        <a href="{{ route('memberships.show', $application) }}" class="btn btn-sm btn-warning">Review</a>
                                        @else
                                        <a href="{{ route('memberships.show', $application) }}" class="btn btn-sm btn-info">View</a>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted">No recent applications</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <a href="{{ route('memberships.index') }}" class="btn btn-sm btn-primary">View All Applications</a>
                    @if($stats['pending_memberships'] > 0)
                    <span class="badge badge-warning ml-2">{{ $stats['pending_memberships'] }} pending reviews</span>
                    @endif
                </div>
            </div>
        </div>

        <!-- Front Office Actions -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Member Services</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('memberships.create') }}" class="btn btn-success">
                            <i class="fas fa-user-plus"></i> Register New Member
                        </a>
                        <a href="{{ route('memberships.index') }}?status=pending" class="btn btn-warning">
                            <i class="fas fa-clipboard-check"></i> Process Applications
                        </a>
                        <a href="{{ route('users.index') }}" class="btn btn-info">
                            <i class="fas fa-users-cog"></i> Manage Members
                        </a>
                        <a href="{{ route('transactions.create') }}" class="btn btn-secondary">
                            <i class="fas fa-exchange-alt"></i> Process Transaction
                        </a>
                    </div>
                </div>
            </div>

            <!-- Service Requests -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Service Requests</h3>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            ID Card Requests
                            <span class="badge badge-primary badge-pill">3</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            Statement Requests
                            <span class="badge badge-success badge-pill">7</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            Loan Applications
                            <span class="badge badge-warning badge-pill">12</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            Account Updates
                            <span class="badge badge-info badge-pill">5</span>
                        </a>
                    </div>
                </div>
                <div class="card-footer">
                    <small class="text-muted">Last updated: {{ now()->format('H:i') }}</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Member Communication -->
    <div class="row mt-3">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Communication Center</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button class="btn btn-outline-primary" onclick="sendBulkMessage()">
                            <i class="fas fa-envelope"></i> Send Bulk SMS
                        </button>
                        <button class="btn btn-outline-success" onclick="sendBulkEmail()">
                            <i class="fas fa-mail-bulk"></i> Send Bulk Email
                        </button>
                        <button class="btn btn-outline-info" onclick="createAnnouncement()">
                            <i class="fas fa-bullhorn"></i> Create Announcement
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Today's Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-right">
                                <h4 class="text-success">{{ rand(5, 15) }}</h4>
                                <small class="text-muted">Applications Processed</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-info">{{ rand(10, 25) }}</h4>
                            <small class="text-muted">Member Inquiries</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-right">
                                <h4 class="text-warning">{{ rand(3, 8) }}</h4>
                                <small class="text-muted">Pending Tasks</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-danger">{{ rand(1, 5) }}</h4>
                            <small class="text-muted">Escalations</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function sendBulkMessage() {
    alert('Bulk SMS feature coming soon!');
}

function sendBulkEmail() {
    alert('Bulk Email feature coming soon!');
}

function createAnnouncement() {
    alert('Announcement feature coming soon!');
}
</script>
