@extends('member.layout')

@section('title', '')

@section('content')
<style>
/* Sleek Dashboard Styling */
.card {
    border: none;
    border-radius: 16px;
    box-shadow: 0 2px 20px rgba(0,0,0,0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    background: #ffffff;
}

.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 40px rgba(0,0,0,0.12);
}

.metric-card {
    color: #2d3748;
    border-radius: 8px;
    padding: 0.75rem;
    position: relative;
    min-height: 80px;
    border: 1px solid #e2e8f0;
}

.metric-card.savings {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}

.metric-card.loans {
    background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    color: white;
}

.metric-card.shares {
    background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    color: white;
}

.metric-card.money-market {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.metric-card.net {
    background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
    color: #2d3748;
}

.welcome-section {
    background: transparent;
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 1rem;
    color: #2d3748;
    position: relative;
    border: 2px solid #28a745;
}

.quick-action-card {
    border-radius: 8px;
    border: 1px solid #e2e8f0;
    transition: all 0.3s ease;
    padding: 1rem;
}

.quick-action-card:hover {
    border-color: #667eea;
    box-shadow: 0 2px 10px rgba(102, 126, 234, 0.1);
}

.btn-sleek {
    border-radius: 6px;
    padding: 0.25rem 0.5rem;
    font-weight: 500;
    font-size: 0.75rem;
    transition: all 0.3s ease;
    border: none;
}

.btn-sleek:hover {
    transform: translateY(-0.5px);
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.stats-number {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 0.125rem;
}

.stats-label {
    font-size: 0.7rem;
    opacity: 0.9;
    font-weight: 500;
}

@media (max-width: 768px) {
    .welcome-section {
        padding: 2rem 1.5rem;
    }

    .metric-card {
        padding: 1.5rem;
    }

    .stats-number {
        font-size: 2rem;
    }
}
</style>
<!-- Clean Welcome Section -->
<div class="welcome-section">
    <div class="row align-items-center">
        <div class="col-lg-8">
            <h3 class="font-weight-bold mb-1 text-dark" style="font-size: 1.5rem;">Welcome back, {{ auth()->user()->first_name }}</h3>
            <p class="mb-0 text-muted" style="font-size: 0.9rem;">Your financial dashboard • {{ now()->format('F Y') }}</p>
        </div>
        <div class="col-lg-4 text-lg-right">
            <div class="d-flex justify-content-lg-end justify-content-center mt-2 mt-lg-0">
                <div class="text-center mx-1">
                    <div class="font-weight-bold mb-0 text-dark" style="font-size: 1rem;">{{ auth()->user()->membership->membership_number ?? 'N/A' }}</div>
                    <div class="small text-muted" style="font-size: 0.7rem;">Member ID</div>
                </div>
                <div class="text-center mx-1">
                    <div class="font-weight-bold mb-0 text-dark" style="font-size: 1rem;">{{ auth()->user()->branch->name ?? 'N/A' }}</div>
                    <div class="small text-muted" style="font-size: 0.7rem;">Branch</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Sleek Metrics Cards -->
<div class="row mb-5">
    <!-- Total Savings -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-4">
        <div class="metric-card savings">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="stats-label">Total Savings</div>
                    <div class="stats-number">KSh {{ number_format($totalSavings, 0) }}</div>
                    <div class="small opacity-75">
                        <i class="fas fa-arrow-up mr-1"></i>
                        @if($savingsGrowth > 0)
                            +{{ number_format($savingsGrowth, 1) }}% this month
                        @elseif($savingsGrowth < 0)
                            {{ number_format($savingsGrowth, 1) }}% this month
                        @else
                            No change this month
                        @endif
                    </div>
                </div>
                <div class="text-right">
                    <i class="fas fa-piggy-bank fa-lg opacity-75"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Loans -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-4">
        <div class="metric-card loans">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="stats-label">Active Loans</div>
                    <div class="stats-number">KSh {{ number_format($totalLoans, 0) }}</div>
                    <div class="small opacity-75">
                        <i class="fas fa-money-bill-wave mr-1"></i>
                        {{ $activeLoans }} active loan{{ $activeLoans !== 1 ? 's' : '' }}
                    </div>
                </div>
                <div class="text-right">
                    <i class="fas fa-money-bill-wave fa-lg opacity-75"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Share Holdings -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-4">
        <div class="metric-card shares">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="stats-label">Share Value</div>
                    <div class="stats-number">KSh {{ number_format($totalShares, 0) }}</div>
                    <div class="small opacity-75">
                        <i class="fas fa-share-alt mr-1"></i>
                        {{ number_format($totalSharesCount) }} share{{ $totalSharesCount !== 1 ? 's' : '' }} owned
                    </div>
                </div>
                <div class="text-right">
                    <i class="fas fa-share-alt fa-lg opacity-75"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Money Market Investments -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-4">
        <div class="metric-card money-market">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="stats-label">Money Market</div>
                    <div class="stats-number">KSh {{ number_format($totalMoneyMarket, 0) }}</div>
                    <div class="small opacity-75">
                        <i class="fas fa-chart-line mr-1"></i>
                        Fixed-term investments
                    </div>
                </div>
                <div class="text-right">
                    <i class="fas fa-chart-line fa-lg opacity-75"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Net Position -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-4">
        <div class="metric-card net">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="stats-label">Net Position</div>
                    <div class="stats-number">KSh {{ number_format(abs($totalSavings + $totalShares + $totalMoneyMarket - $totalLoans), 0) }}</div>
                    <div class="small opacity-75">
                        <i class="fas {{ ($totalSavings + $totalShares + $totalMoneyMarket - $totalLoans) >= 0 ? 'fa-chart-line' : 'fa-chart-line-down' }} mr-1"></i>
                        {{ ($totalSavings + $totalShares + $totalMoneyMarket - $totalLoans) >= 0 ? 'Positive' : 'Negative' }} balance
                    </div>
                </div>
                <div class="text-right">
                    <i class="fas {{ ($totalSavings + $totalShares + $totalMoneyMarket - $totalLoans) >= 0 ? 'fa-chart-line' : 'fa-chart-line-down' }} fa-lg opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Sleek Quick Actions -->
<div class="row mb-5">
    <div class="col-12">
        <div class="text-center mb-4">
            <h2 class="font-weight-light text-muted mb-4">Quick Actions</h2>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="quick-action-card text-center">
                    <div class="mb-1">
                        <i class="fas fa-plus-circle fa-lg text-primary"></i>
                    </div>
                    <h6 class="font-weight-bold mb-1" style="font-size: 0.8rem;">Apply for Loan</h6>
                    <p class="text-muted mb-1" style="font-size: 0.7rem;">Get financing for your needs</p>
                    <a href="{{ route('member.loans.create') }}" class="btn btn-primary btn-sleek">
                        <i class="fas fa-arrow-right"></i>Apply Now
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="quick-action-card text-center">
                    <div class="mb-1">
                        <i class="fas fa-piggy-bank fa-lg text-success"></i>
                    </div>
                    <h6 class="font-weight-bold mb-1" style="font-size: 0.8rem;">Open Savings</h6>
                    <p class="text-muted mb-1" style="font-size: 0.7rem;">Start building your savings</p>
                    <a href="{{ route('member.savings.create') }}" class="btn btn-success btn-sleek">
                        <i class="fas fa-arrow-right"></i>Open Account
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="quick-action-card text-center">
                    <div class="mb-1">
                        <i class="fas fa-user fa-lg text-info"></i>
                    </div>
                    <h6 class="font-weight-bold mb-1" style="font-size: 0.8rem;">Update Profile</h6>
                    <p class="text-muted mb-1" style="font-size: 0.7rem;">Manage your information</p>
                    <a href="{{ route('member.profile') }}" class="btn btn-info btn-sleek">
                        <i class="fas fa-arrow-right"></i>Update Now
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="quick-action-card text-center">
                    <div class="mb-1">
                        <i class="fas fa-chart-line fa-lg text-warning"></i>
                    </div>
                    <h6 class="font-weight-bold mb-1" style="font-size: 0.8rem;">Money Market</h6>
                    <p class="text-muted mb-1" style="font-size: 0.7rem;">Fixed-term investments</p>
                    <a href="{{ route('member.money-market.index') }}" class="btn btn-warning btn-sleek">
                        <i class="fas fa-arrow-right"></i>View Investments
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="quick-action-card text-center">
                    <div class="mb-1">
                        <i class="fas fa-calculator fa-lg text-secondary"></i>
                    </div>
                    <h6 class="font-weight-bold mb-1" style="font-size: 0.8rem;">Investment Calculator</h6>
                    <p class="text-muted mb-1" style="font-size: 0.7rem;">Plan your investments</p>
                    <a href="{{ route('member.money-market.calculator') }}" class="btn btn-secondary btn-sleek">
                        <i class="fas fa-arrow-right"></i>Calculate
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

