@extends('member.layout')

@section('title', 'Apply for Loan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-money-bill-wave mr-2"></i>Loan Application
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-primary">New Application</span>
                    </div>
                </div>

                <form action="{{ route('member.loans.store') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="row">
                            <!-- Left Column: Application Details -->
                            <div class="col-md-6">
                                <div class="border-right pr-4">
                                    <h5 class="text-primary mb-3">
                                        <i class="fas fa-file-alt mr-2"></i>Application Details
                                    </h5>

                                    <div class="form-group">
                                        <label for="amount" class="form-label">Loan Amount (KSh)</label>
                                        <input type="number" name="amount" id="amount" value="{{ old('amount') }}"
                                                class="form-control form-control-sm @error('amount') is-invalid @enderror"
                                                min="1000" max="500000" step="0.01" required>
                                        @error('amount')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">Minimum: KSh 1,000 | Maximum: KSh 500,000</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="application_date" class="form-label">Application Date</label>
                                        <input type="date" name="application_date" id="application_date"
                                                value="{{ old('application_date', date('Y-m-d')) }}"
                                                class="form-control form-control-sm @error('application_date') is-invalid @enderror" required>
                                        @error('application_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="return_date" class="form-label">Return Date</label>
                                        <input type="date" name="return_date" id="return_date" value="{{ old('return_date') }}"
                                                class="form-control form-control-sm @error('return_date') is-invalid @enderror" required>
                                        @error('return_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="purpose" class="form-label">Loan Purpose</label>
                                        <textarea name="purpose" id="purpose" rows="3"
                                                  class="form-control form-control-sm @error('purpose') is-invalid @enderror"
                                                  placeholder="Please describe the purpose of your loan application..." required>{{ old('purpose') }}</textarea>
                                        @error('purpose')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column: Calculator & Guarantees -->
                            <div class="col-md-6">
                                <div class="pl-4">
                                    <!-- Loan Calculator -->
                                    <h5 class="text-info mb-3">
                                        <i class="fas fa-calculator mr-2"></i>Loan Calculator
                                    </h5>

                                    <div class="row mb-3">
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Principal</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-principal" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Interest</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-interest" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Total Amount</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-total" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Monthly Payment</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-monthly" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Important Information -->
                                    <h5 class="text-secondary mb-3 mt-4">
                                        <i class="fas fa-info-circle mr-2"></i>Important Information
                                    </h5>

                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Interest Rate</label>
                                                <input type="text" value="{{ $defaultInterestRate ?? 30 }}% per annum" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Processing Time</label>
                                                <input type="text" value="2-3 days" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Payment Method</label>
                                                <input type="text" value="M-Pesa" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer text-right">
                        <a href="{{ route('member.loans.index') }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-paper-plane mr-1"></i>Submit Application
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('js')
<script>
$(document).ready(function() {
    const $amountInput = $('#amount');
    const $applicationDateInput = $('#application_date');
    const $returnDateInput = $('#return_date');


    function calculateLoan() {
        const amount = parseFloat($amountInput.val()) || 0;
        const applicationDate = $applicationDateInput.val();
        const returnDate = $returnDateInput.val();
        const interestRate = {{ $defaultInterestRate ?? 30 }}; // Dynamic interest rate from config

        let termMonths = 0;
        if (applicationDate && returnDate) {
            const startDate = new Date(applicationDate);
            const endDate = new Date(returnDate);
            const timeDiff = endDate.getTime() - startDate.getTime();
            termMonths = Math.ceil(timeDiff / (1000 * 3600 * 24 * 30)); // Approximate months
            termMonths = Math.max(1, termMonths); // Minimum 1 month
        }

        const interestAmount = amount * (interestRate / 100);
        const totalAmount = amount + interestAmount;
        const monthlyPayment = termMonths > 0 ? totalAmount / termMonths : 0;

        $('#preview-principal').val('KSh ' + amount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-interest').val('KSh ' + interestAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-total').val('KSh ' + totalAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-monthly').val('KSh ' + monthlyPayment.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $amountInput.on('input', calculateLoan);
    $applicationDateInput.on('change', calculateLoan);
    $returnDateInput.on('change', calculateLoan);

    // Initial calculation
    calculateLoan();

});
</script>
@endpush
@endsection
