@extends('member.layout')

@section('title', 'Edit Loan Application')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-edit mr-2"></i>Edit Loan Application
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-warning">Pending Application</span>
                    </div>
                </div>

                <form action="{{ route('member.loans.update', $loan) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="card-body">
                        <div class="row">
                            <!-- Left Column: Application Details -->
                            <div class="col-md-6">
                                <div class="border-right pr-4">
                                    <h5 class="text-primary mb-3">
                                        <i class="fas fa-file-alt mr-2"></i>Application Details
                                    </h5>

                                    <div class="form-group">
                                        <label for="amount" class="form-label">Loan Amount (KSh)</label>
                                        <input type="number" name="amount" id="amount" value="{{ old('amount', $loan->amount) }}"
                                                class="form-control form-control-sm @error('amount') is-invalid @enderror"
                                                min="1000" max="500000" step="0.01" required>
                                        @error('amount')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">Minimum: KSh 1,000 | Maximum: KSh 500,000</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="application_date" class="form-label">Application Date</label>
                                        <input type="date" name="application_date" id="application_date"
                                                value="{{ old('application_date', $loan->application_date ? $loan->application_date->format('Y-m-d') : date('Y-m-d')) }}"
                                                class="form-control form-control-sm @error('application_date') is-invalid @enderror" required>
                                        @error('application_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="return_date" class="form-label">Return Date</label>
                                        <input type="date" name="return_date" id="return_date"
                                                value="{{ old('return_date', $loan->return_date ? $loan->return_date->format('Y-m-d') : '') }}"
                                                class="form-control form-control-sm @error('return_date') is-invalid @enderror" required>
                                        @error('return_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="purpose" class="form-label">Loan Purpose</label>
                                        <textarea name="purpose" id="purpose" rows="3"
                                                  class="form-control form-control-sm @error('purpose') is-invalid @enderror"
                                                  placeholder="Please describe the purpose of your loan application..." required>{{ old('purpose', $loan->notes) }}</textarea>
                                        @error('purpose')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column: Calculator & Guarantees -->
                            <div class="col-md-6">
                                <div class="pl-4">
                                    <!-- Loan Calculator -->
                                    <h5 class="text-info mb-3">
                                        <i class="fas fa-calculator mr-2"></i>Loan Calculator
                                    </h5>

                                    <div class="row mb-3">
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Principal</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-principal" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Interest</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-interest" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Total Amount</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-total" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Monthly Payment</label>
                                                <input type="text" class="form-control form-control-sm bg-light" id="preview-monthly" readonly value="KSh 0.00">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Important Information -->
                                    <h5 class="text-secondary mb-3 mt-4">
                                        <i class="fas fa-info-circle mr-2"></i>Important Information
                                    </h5>

                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Interest Rate</label>
                                                <input type="text" value="{{ $defaultInterestRate ?? 30 }}% per annum" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Processing Time</label>
                                                <input type="text" value="2-3 days" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Payment Method</label>
                                                <input type="text" value="M-Pesa" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Security & Guarantees Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary py-2">
                                        <h6 class="card-title mb-0 text-white">
                                            <i class="fas fa-shield-alt mr-2"></i>SECURITY & GUARANTEES
                                        </h6>
                                        <div class="card-tools">
                                            <div class="btn-group btn-group-sm">
                                                <button type="button" class="btn btn-outline-light btn-xs" id="add-salary-guarantee">
                                                    <i class="fas fa-briefcase mr-1"></i>Salary
                                                </button>
                                                <button type="button" class="btn btn-outline-light btn-xs" id="add-collateral-guarantee">
                                                    <i class="fas fa-home mr-1"></i>Collateral
                                                </button>
                                                <button type="button" class="btn btn-outline-light btn-xs" id="add-guarantor">
                                                    <i class="fas fa-users mr-1"></i>Guarantor
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body py-2">
                                        <div id="guarantees-container">
                                            <!-- Existing guarantees will be loaded here -->
                                            @if($loan->guarantees)
                                                @foreach($loan->guarantees as $guarantee)
                                                    @if($guarantee->guarantee_type === 'salary' && $guarantee->salaryGuarantee)
                                                        <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="salary" data-index="{{ $loop->index }}">
                                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                                <h6 class="mb-0"><i class="fas fa-briefcase text-success mr-2"></i>Salary Guarantee</h6>
                                                                <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                            <input type="hidden" name="guarantees[{{ $loop->index }}][type]" value="salary">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Employer Name <span class="text-danger">*</span></label>
                                                                        <input type="text" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][employer_name]" value="{{ $guarantee->salaryGuarantee->employer_name }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Employer Phone</label>
                                                                        <input type="tel" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][employer_phone]" value="{{ $guarantee->salaryGuarantee->employer_phone }}">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <div class="form-group">
                                                                        <label>Employer Address <span class="text-danger">*</span></label>
                                                                        <input type="text" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][employer_address]" value="{{ $guarantee->salaryGuarantee->employer_address }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label>Monthly Salary (KSh) <span class="text-danger">*</span></label>
                                                                        <input type="number" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][monthly_salary]" value="{{ $guarantee->salaryGuarantee->monthly_salary }}" min="0" step="0.01" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Employee Position <span class="text-danger">*</span></label>
                                                                        <input type="text" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][employee_position]" value="{{ $guarantee->salaryGuarantee->employee_position }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Employment Start Date <span class="text-danger">*</span></label>
                                                                        <input type="date" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][salary][employment_start_date]" value="{{ $guarantee->salaryGuarantee->employment_start_date ? $guarantee->salaryGuarantee->employment_start_date->format('Y-m-d') : '' }}" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @elseif($guarantee->guarantee_type === 'collateral' && $guarantee->collateral)
                                                        <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="collateral" data-index="{{ $loop->index }}">
                                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                                <h6 class="mb-0"><i class="fas fa-home text-info mr-2"></i>Collateral Guarantee</h6>
                                                                <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                            <input type="hidden" name="guarantees[{{ $loop->index }}][type]" value="collateral">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Item Type <span class="text-danger">*</span></label>
                                                                        <select class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][item_type]" required>
                                                                            <option value="">Select Item Type</option>
                                                                            <option value="vehicle" {{ $guarantee->collateral->item_type === 'vehicle' ? 'selected' : '' }}>Vehicle</option>
                                                                            <option value="land" {{ $guarantee->collateral->item_type === 'land' ? 'selected' : '' }}>Land/Property</option>
                                                                            <option value="house" {{ $guarantee->collateral->item_type === 'house' ? 'selected' : '' }}>House</option>
                                                                            <option value="machinery" {{ $guarantee->collateral->item_type === 'machinery' ? 'selected' : '' }}>Machinery/Equipment</option>
                                                                            <option value="other" {{ $guarantee->collateral->item_type === 'other' ? 'selected' : '' }}>Other</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Estimated Value (KSh) <span class="text-danger">*</span></label>
                                                                        <input type="number" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][estimated_value]" value="{{ $guarantee->collateral->estimated_value }}" min="0" step="0.01" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label>Item Description <span class="text-danger">*</span></label>
                                                                        <textarea class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][item_description]" rows="2" required>{{ $guarantee->collateral->item_description }}</textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Ownership Document Type <span class="text-danger">*</span></label>
                                                                        <select class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][ownership_document_type]" required>
                                                                            <option value="">Select Document Type</option>
                                                                            <option value="title_deed" {{ $guarantee->collateral->ownership_document_type === 'title_deed' ? 'selected' : '' }}>Title Deed</option>
                                                                            <option value="log_book" {{ $guarantee->collateral->ownership_document_type === 'log_book' ? 'selected' : '' }}>Log Book</option>
                                                                            <option value="receipt" {{ $guarantee->collateral->ownership_document_type === 'receipt' ? 'selected' : '' }}>Purchase Receipt</option>
                                                                            <option value="certificate" {{ $guarantee->collateral->ownership_document_type === 'certificate' ? 'selected' : '' }}>Ownership Certificate</option>
                                                                            <option value="other" {{ $guarantee->collateral->ownership_document_type === 'other' ? 'selected' : '' }}>Other Document</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Document Number <span class="text-danger">*</span></label>
                                                                        <input type="text" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][ownership_document_number]" value="{{ $guarantee->collateral->ownership_document_number }}" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Document Date <span class="text-danger">*</span></label>
                                                                        <input type="date" class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][ownership_document_date]" value="{{ $guarantee->collateral->ownership_document_date ? $guarantee->collateral->ownership_document_date->format('Y-m-d') : '' }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Ownership Document</label>
                                                                        <input type="file" class="form-control-file" name="guarantees[{{ $loop->index }}][collateral][document_file]" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label>Ownership Details</label>
                                                                        <textarea class="form-control form-control-sm" name="guarantees[{{ $loop->index }}][collateral][ownership_details]" rows="2" placeholder="Additional ownership information">{{ $guarantee->collateral->ownership_details }}</textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @elseif($guarantee->guarantee_type === 'guarantor' && $guarantee->guarantors->count() > 0)
                                                        @foreach($guarantee->guarantors as $guarantor)
                                                        <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="guarantor" data-index="{{ $loop->parent->index }}">
                                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                                <h6 class="mb-0"><i class="fas fa-users text-primary mr-2"></i>Guarantor</h6>
                                                                <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                            <input type="hidden" name="guarantees[{{ $loop->parent->index }}][type]" value="guarantor">
                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <div class="form-group">
                                                                        <label>Guarantor (Member) <span class="text-danger">*</span></label>
                                                                        <select class="form-control form-control-sm guarantor-select" name="guarantees[{{ $loop->parent->index }}][guarantor][guarantor_user_id]" required>
                                                                            <option value="">Select Guarantor</option>
                                                                            @foreach($users ?? [] as $user)
                                                                            <option value="{{ $user->id }}" {{ $guarantor->guarantor_user_id == $user->id ? 'selected' : '' }}>{{ $user->full_name ?? $user->name }} ({{ $user->id_number }})</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label>Guarantee Amount (KSh) <span class="text-danger">*</span></label>
                                                                        <input type="number" class="form-control form-control-sm" name="guarantees[{{ $loop->parent->index }}][guarantor][guarantee_amount]" value="{{ $guarantor->guarantee_amount }}" min="0" step="0.01" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Relationship Type <span class="text-danger">*</span></label>
                                                                        <select class="form-control form-control-sm" name="guarantees[{{ $loop->parent->index }}][guarantor][relationship_type]" required>
                                                                            <option value="">Select Relationship</option>
                                                                            <option value="family" {{ $guarantor->relationship_type === 'family' ? 'selected' : '' }}>Family Member</option>
                                                                            <option value="friend" {{ $guarantor->relationship_type === 'friend' ? 'selected' : '' }}>Friend</option>
                                                                            <option value="colleague" {{ $guarantor->relationship_type === 'colleague' ? 'selected' : '' }}>Colleague</option>
                                                                            <option value="other" {{ $guarantor->relationship_type === 'other' ? 'selected' : '' }}>Other</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>Relationship Details</label>
                                                                        <input type="text" class="form-control form-control-sm" name="guarantees[{{ $loop->parent->index }}][guarantor][relationship_details]" value="{{ $guarantor->relationship_details }}" placeholder="Additional relationship details">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endforeach
                                                    @endif
                                                @endforeach
                                            @endif
                                        </div>
                                        @error('guarantee')
                                            <div class="alert alert-danger alert-sm mt-2 mb-0">
                                                <i class="fas fa-exclamation-triangle mr-1"></i>{{ $message }}
                                            </div>
                                        @enderror

                                        <div class="text-muted small mt-2">
                                            <i class="fas fa-info-circle mr-1"></i>
                                            Add security/guarantee for the loan application to improve approval chances.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer text-right">
                        <a href="{{ route('member.loans.show', $loan) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-save mr-1"></i>Update Application
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('js')
<script>
$(document).ready(function() {
    const $amountInput = $('#amount');
    const $applicationDateInput = $('#application_date');
    const $returnDateInput = $('#return_date');

    let guaranteeCounter = {{ $loan->guarantees ? $loan->guarantees->count() : 0 }};

    function calculateLoan() {
        const amount = parseFloat($amountInput.val()) || 0;
        const applicationDate = $applicationDateInput.val();
        const returnDate = $returnDateInput.val();
        const interestRate = {{ $defaultInterestRate ?? 30 }}; // Dynamic interest rate from config

        let termMonths = 0;
        if (applicationDate && returnDate) {
            const startDate = new Date(applicationDate);
            const endDate = new Date(returnDate);
            const timeDiff = endDate.getTime() - startDate.getTime();
            termMonths = Math.ceil(timeDiff / (1000 * 3600 * 24 * 30)); // Approximate months
            termMonths = Math.max(1, termMonths); // Minimum 1 month
        }

        const interestAmount = amount * (interestRate / 100);
        const totalAmount = amount + interestAmount;
        const monthlyPayment = termMonths > 0 ? totalAmount / termMonths : 0;

        $('#preview-principal').val('KSh ' + amount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-interest').val('KSh ' + interestAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-total').val('KSh ' + totalAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-monthly').val('KSh ' + monthlyPayment.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $amountInput.on('input', calculateLoan);
    $applicationDateInput.on('change', calculateLoan);
    $returnDateInput.on('change', calculateLoan);

    // Initial calculation
    calculateLoan();

    // Add Salary Guarantee
    $('#add-salary-guarantee').on('click', function() {
        addSalaryGuarantee();
    });

    // Add Collateral Guarantee
    $('#add-collateral-guarantee').on('click', function() {
        addCollateralGuarantee();
    });

    // Add Guarantor
    $('#add-guarantor').on('click', function() {
        addGuarantor();
    });

    function addSalaryGuarantee() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="salary" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-briefcase text-success mr-2"></i>Salary Guarantee</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="salary">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employer Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-sm" name="guarantees[${index}][salary][employer_name]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employer Phone</label>
                            <input type="tel" class="form-control form-control-sm" name="guarantees[${index}][salary][employer_phone]">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label>Employer Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-sm" name="guarantees[${index}][salary][employer_address]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Monthly Salary (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control form-control-sm" name="guarantees[${index}][salary][monthly_salary]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employee Position <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-sm" name="guarantees[${index}][salary][employee_position]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employment Start Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control form-control-sm" name="guarantees[${index}][salary][employment_start_date]" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Employment Letter</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][employment_letter]" accept=".pdf,.doc,.docx">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Confirmation Letter</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][confirmation_letter]" accept=".pdf,.doc,.docx">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Payslips (2 months)</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][payslips][]" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#guarantees-container').append(html);
    }

    function addCollateralGuarantee() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="collateral" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-home text-info mr-2"></i>Collateral Guarantee</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="collateral">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Item Type <span class="text-danger">*</span></label>
                            <select class="form-control form-control-sm" name="guarantees[${index}][collateral][item_type]" required>
                                <option value="">Select Item Type</option>
                                <option value="vehicle">Vehicle</option>
                                <option value="land">Land/Property</option>
                                <option value="house">House</option>
                                <option value="machinery">Machinery/Equipment</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Estimated Value (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control form-control-sm" name="guarantees[${index}][collateral][estimated_value]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Item Description <span class="text-danger">*</span></label>
                            <textarea class="form-control form-control-sm" name="guarantees[${index}][collateral][item_description]" rows="2" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Ownership Document Type <span class="text-danger">*</span></label>
                            <select class="form-control form-control-sm" name="guarantees[${index}][collateral][ownership_document_type]" required>
                                <option value="">Select Document Type</option>
                                <option value="title_deed">Title Deed</option>
                                <option value="log_book">Log Book</option>
                                <option value="receipt">Purchase Receipt</option>
                                <option value="certificate">Ownership Certificate</option>
                                <option value="other">Other Document</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Document Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-sm" name="guarantees[${index}][collateral][ownership_document_number]" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Document Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control form-control-sm" name="guarantees[${index}][collateral][ownership_document_date]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Ownership Document</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][collateral][document_file]" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Ownership Details</label>
                            <textarea class="form-control form-control-sm" name="guarantees[${index}][collateral][ownership_details]" rows="2" placeholder="Additional ownership information"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#guarantees-container').append(html);
    }

    function addGuarantor() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="guarantor" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-users text-primary mr-2"></i>Guarantor</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="guarantor">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label>Guarantor (Member) <span class="text-danger">*</span></label>
                            <select class="form-control form-control-sm guarantor-select" name="guarantees[${index}][guarantor][guarantor_user_id]" required>
                                <option value="">Select Guarantor</option>
                                @foreach($users ?? [] as $user)
                                <option value="{{ $user->id }}">{{ $user->full_name ?? $user->name }} ({{ $user->id_number }})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Guarantee Amount (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control form-control-sm" name="guarantees[${index}][guarantor][guarantee_amount]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Relationship Type <span class="text-danger">*</span></label>
                            <select class="form-control form-control-sm" name="guarantees[${index}][guarantor][relationship_type]" required>
                                <option value="">Select Relationship</option>
                                <option value="family">Family Member</option>
                                <option value="friend">Friend</option>
                                <option value="colleague">Colleague</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Relationship Details</label>
                            <input type="text" class="form-control form-control-sm" name="guarantees[${index}][guarantor][relationship_details]" placeholder="Additional relationship details">
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#guarantees-container').append(html);
    }

    // Remove guarantee
    $(document).on('click', '.remove-guarantee', function() {
        $(this).closest('.guarantee-item').remove();
    });
});
</script>
@endpush
@endsection
