@extends('member.layout')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Welcome Section -->
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">My Money Market Investments</h4>
                    <p class="card-text">Track your fixed-term investments and monitor their growth over time.</p>
                    <a href="{{ route('member.money-market.calculator') }}" class="btn btn-outline-primary">
                        <i class="fas fa-calculator"></i> Investment Calculator
                    </a>
                </div>
            </div>

            <!-- Statistics Cards -->
            @if($stats['total_accounts'] > 0)
            <div class="row mt-4">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ number_format($stats['total_accounts']) }}</h3>
                            <p>Total Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{ number_format($stats['active_accounts']) }}</h3>
                            <p>Active Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-play-circle"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{ number_format($stats['matured_accounts']) }}</h3>
                            <p>Matured Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-primary">
                        <div class="inner">
                            <h3>{{ \App\Helpers\CurrencyHelper::format($stats['total_value'], 'KES') }}</h3>
                            <p>Total Portfolio Value</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Investments Table -->
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title">My Investments</h3>
                </div>
                <div class="card-body">
                    @if($moneyMarketAccounts->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Account Number</th>
                                    <th>Principal Amount</th>
                                    <th>Interest Rate</th>
                                    <th>Term</th>
                                    <th>Start Date</th>
                                    <th>Maturity Date</th>
                                    <th>Interest Earned</th>
                                    <th>Total Value</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($moneyMarketAccounts as $account)
                                <tr>
                                    <td>{{ $account->account_number }}</td>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($account->principal_amount, $account->currency_code) }}</td>
                                    <td>{{ number_format($account->interest_rate, 2) }}%</td>
                                    <td>{{ $account->term_months }} months</td>
                                    <td>{{ $account->start_date->format('M d, Y') }}</td>
                                    <td>{{ $account->maturity_date->format('M d, Y') }}</td>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($account->interest_earned, $account->currency_code) }}</td>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($account->total_amount, $account->currency_code) }}</td>
                                    <td>
                                        <span class="badge {{ $account->getStatusBadgeClass() }}">
                                            {{ ucfirst($account->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('member.money-market.show', $account) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        @if($account->status === 'active' || $account->status === 'matured')
                                        <button type="button" class="btn btn-danger btn-sm ml-1" onclick="requestWithdrawal({{ $account->id }}, '{{ $account->account_number }}')">
                                            <i class="fas fa-money-bill-wave"></i> Withdraw
                                        </button>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-5">
                        <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                        <h4>No Money Market Investments Yet</h4>
                        <p class="text-muted">You don't have any money market investments at the moment.</p>
                        <p class="text-muted">Contact your Sacco administrator to open a money market account.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function requestWithdrawal(accountId, accountNumber) {
    const reason = prompt(`Please provide a reason for withdrawing from account ${accountNumber}:`);
    if (reason !== null && reason.trim() !== '') {
        if (confirm('Are you sure you want to request withdrawal from this account? This action cannot be undone and requires admin approval.')) {
            // Create a form and submit it
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `{{ url('member/money-market') }}/${accountId}/request-withdrawal`;

            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '{{ csrf_token() }}';

            const amountInput = document.createElement('input');
            amountInput.type = 'hidden';
            amountInput.name = 'withdrawal_amount';
            amountInput.value = '0'; // Full withdrawal

            const reasonInput = document.createElement('input');
            reasonInput.type = 'hidden';
            reasonInput.name = 'reason';
            reasonInput.value = reason;

            form.appendChild(tokenInput);
            form.appendChild(amountInput);
            form.appendChild(reasonInput);
            document.body.appendChild(form);
            form.submit();
        }
    } else if (reason !== null) {
        alert('Please provide a reason for the withdrawal request.');
    }
}
</script>
@endsection
