@extends('member.layout')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Account Header -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        Investment Details: {{ $moneyMarketAccount->account_number }}
                        <span class="badge {{ $moneyMarketAccount->getStatusBadgeClass() }} ml-2">
                            {{ ucfirst($moneyMarketAccount->status) }}
                        </span>
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('member.money-market.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Investments
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Investment Information -->
                        <div class="col-md-6">
                            <h5>Investment Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Account Number:</th>
                                    <td>{{ $moneyMarketAccount->account_number }}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <span class="badge {{ $moneyMarketAccount->getStatusBadgeClass() }}">
                                            {{ ucfirst($moneyMarketAccount->status) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Currency:</th>
                                    <td>{{ $moneyMarketAccount->currency_code }}</td>
                                </tr>
                            </table>
                        </div>

                        <!-- Investment Terms -->
                        <div class="col-md-6">
                            <h5>Investment Terms</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Principal Amount:</th>
                                    <td>{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code) }}</td>
                                </tr>
                                <tr>
                                    <th>Interest Rate:</th>
                                    <td>{{ number_format($moneyMarketAccount->interest_rate, 2) }}% per annum</td>
                                </tr>
                                <tr>
                                    <th>Term:</th>
                                    <td>{{ $moneyMarketAccount->term_months }} months</td>
                                </tr>
                                <tr>
                                    <th>Start Date:</th>
                                    <td>{{ $moneyMarketAccount->start_date->format('M d, Y') }}</td>
                                </tr>
                                <tr>
                                    <th>Maturity Date:</th>
                                    <td>{{ $moneyMarketAccount->maturity_date->format('M d, Y') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <!-- Financial Summary -->
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Financial Summary</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="card border-primary">
                                        <div class="card-body text-center">
                                            <h6 class="card-title">Principal Amount</h6>
                                            <h4 class="text-primary">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code) }}</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card border-success">
                                        <div class="card-body text-center">
                                            <h6 class="card-title">Interest Earned</h6>
                                            <h4 class="text-success">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->interest_earned, $moneyMarketAccount->currency_code) }}</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card border-info">
                                        <div class="card-body text-center">
                                            <h6 class="card-title">Total Value</h6>
                                            <h4 class="text-info">{{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->total_amount, $moneyMarketAccount->currency_code) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Progress and Timeline -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <h5>Investment Progress</h5>
                            <div class="progress mb-3">
                                <?php
                                $totalDays = $moneyMarketAccount->start_date->diffInDays($moneyMarketAccount->maturity_date);
                                $elapsedDays = $moneyMarketAccount->start_date->diffInDays(now());
                                $progress = min(100, max(0, ($elapsedDays / $totalDays) * 100));
                                ?>
                                <div class="progress-bar" role="progressbar" style="width: {{ $progress }}%"
                                     aria-valuenow="{{ $progress }}" aria-valuemin="0" aria-valuemax="100">
                                    {{ number_format($progress, 1) }}%
                                </div>
                            </div>
                            <div class="row text-center">
                                <div class="col-md-4">
                                    <strong>Days Elapsed:</strong><br>
                                    {{ $elapsedDays }} days
                                </div>
                                <div class="col-md-4">
                                    <strong>Days Remaining:</strong><br>
                                    {{ max(0, $moneyMarketAccount->daysUntilMaturity()) }} days
                                </div>
                                <div class="col-md-4">
                                    <strong>Total Term:</strong><br>
                                    {{ $totalDays }} days
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($moneyMarketAccount->notes)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Notes</h5>
                            <p>{{ $moneyMarketAccount->notes }}</p>
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    @if($moneyMarketAccount->status === 'active' || $moneyMarketAccount->status === 'matured')
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Actions</h5>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Withdrawal Request:</strong> Clicking the withdrawal button below will submit a request to your Sacco administrator.
                                The request must be approved before any funds are released.
                            </div>
                            <button type="button" class="btn btn-danger btn-lg" onclick="requestWithdrawal()">
                                <i class="fas fa-money-bill-wave"></i> Request Full Withdrawal
                            </button>
                        </div>
                    </div>
                    @endif

                    <!-- Withdrawal History -->
                    @if($moneyMarketAccount->withdrawn_at)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Withdrawal Information</h5>
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <strong>Withdrawal Date:</strong><br>
                                            {{ $moneyMarketAccount->withdrawn_at->format('M d, Y H:i') }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Withdrawal Amount:</strong><br>
                                            {{ \App\Helpers\CurrencyHelper::format($moneyMarketAccount->withdrawal_amount, $moneyMarketAccount->currency_code) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function requestWithdrawal() {
    const reason = prompt('Please provide a reason for withdrawing from this investment:');
    if (reason !== null && reason.trim() !== '') {
        if (confirm('Are you sure you want to request withdrawal from this investment? This will submit a request to your Sacco administrator for approval.')) {
            // Create a form and submit it
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("member.money-market.request-withdrawal", $moneyMarketAccount) }}';

            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '{{ csrf_token() }}';

            const amountInput = document.createElement('input');
            amountInput.type = 'hidden';
            amountInput.name = 'withdrawal_amount';
            amountInput.value = '{{ $moneyMarketAccount->total_amount }}'; // Full amount

            const reasonInput = document.createElement('input');
            reasonInput.type = 'hidden';
            reasonInput.name = 'reason';
            reasonInput.value = reason;

            form.appendChild(tokenInput);
            form.appendChild(amountInput);
            form.appendChild(reasonInput);
            document.body.appendChild(form);
            form.submit();
        }
    } else if (reason !== null) {
        alert('Please provide a reason for the withdrawal request.');
    }
}
</script>
@endsection
