@extends('member.layout')

@section('title', 'My Profile')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-user mr-2"></i>Profile Information
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-primary">Manage Account</span>
                    </div>
                </div>

                <form action="{{ route('member.profile.update') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="card-body">
                        <div class="row">
                            <!-- Left Column: Personal Information (Editable) -->
                            <div class="col-md-6">
                                <div class="border-right pr-4">
                                    <h5 class="text-primary mb-3">
                                        <i class="fas fa-id-card mr-2"></i>Personal Information
                                    </h5>

                                    <div class="form-group">
                                        <label for="first_name" class="form-label">First Name</label>
                                        <input type="text" name="first_name" id="first_name" value="{{ old('first_name', $user->first_name) }}"
                                               class="form-control form-control-sm @error('first_name') is-invalid @enderror" required>
                                        @error('first_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="second_name" class="form-label">Second Name</label>
                                        <input type="text" name="second_name" id="second_name" value="{{ old('second_name', $user->second_name) }}"
                                               class="form-control form-control-sm @error('second_name') is-invalid @enderror" required>
                                        @error('second_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="phone_number" class="form-label">Phone Number</label>
                                        <input type="tel" name="phone_number" id="phone_number" value="{{ old('phone_number', $user->phone_number) }}"
                                               class="form-control form-control-sm @error('phone_number') is-invalid @enderror" required>
                                        @error('phone_number')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="email" class="form-label">Email Address</label>
                                        <input type="email" name="email" id="email" value="{{ old('email', $user->email) }}"
                                               class="form-control form-control-sm @error('email') is-invalid @enderror" required>
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column: Membership & Account Information (Read-only) -->
                            <div class="col-md-6">
                                <div class="pl-4">
                                    <!-- Membership Information -->
                                    <h5 class="text-info mb-3">
                                        <i class="fas fa-users mr-2"></i>Membership Information
                                    </h5>

                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Membership Number</label>
                                                <input type="text" value="{{ $user->membership->membership_number ?? 'N/A' }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Status</label>
                                                <input type="text" value="{{ ucfirst($user->membership->status ?? 'N/A') }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">ID Number</label>
                                                <input type="text" value="{{ $user->id_number }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Branch</label>
                                                <input type="text" value="{{ $user->branch->name ?? 'N/A' }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Joining Date</label>
                                                <input type="text" value="{{ $user->membership->joining_date ? $user->membership->joining_date->format('M d, Y') : 'N/A' }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Gender</label>
                                                <input type="text" value="{{ ucfirst($user->membership->gender ?? 'N/A') }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Account Information -->
                                    <h5 class="text-secondary mb-3 mt-4">
                                        <i class="fas fa-clock mr-2"></i>Account Information
                                    </h5>

                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Account Created</label>
                                                <input type="text" value="{{ $user->created_at->format('M d, Y') }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>

                                        <div class="col-6">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Last Updated</label>
                                                <input type="text" value="{{ $user->updated_at->format('M d, Y') }}" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-save mr-1"></i>Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
