<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Morio Sacco - Loan Repayment Receipt</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #247f1b; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background-color: #f9f9f9; }
        .receipt { background-color: white; padding: 20px; border: 2px solid #247f1b; margin: 20px 0; }
        .receipt-header { border-bottom: 2px solid #247f1b; padding-bottom: 10px; margin-bottom: 15px; }
        .receipt-details { margin: 10px 0; }
        .receipt-total { background-color: #f8f9fa; padding: 10px; border-radius: 5px; margin-top: 15px; }
        .footer { background-color: #333; color: white; padding: 10px; text-align: center; font-size: 12px; }
        .btn { display: inline-block; padding: 10px 20px; background-color: #247f1b; color: white; text-decoration: none; border-radius: 5px; }
        .transaction-info { background-color: #e9ecef; padding: 10px; border-radius: 5px; margin: 15px 0; }
        .loan-info { background-color: #fff3cd; padding: 10px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #ffc107; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Morio Sacco</h1>
            <p>Loan Repayment Receipt</p>
        </div>

        <div class="content">
            <h2>Dear <?php echo e($user->full_name); ?>,</h2>

            <p>Thank you for your loan repayment. This email serves as an official receipt for the transaction below.</p>

            <div class="receipt">
                <div class="receipt-header">
                    <h3 style="margin: 0; color: #247f1b;">Loan Repayment Receipt</h3>
                    <p style="margin: 5px 0 0 0; font-size: 14px;">Receipt Number: <?php echo e($transaction->id); ?></p>
                </div>

                <div class="receipt-details">
                    <p><strong>Member Name:</strong> <?php echo e($user->full_name); ?></p>
                    <p><strong>Membership Number:</strong> <?php echo e($user->membership->membership_number ?? 'N/A'); ?></p>
                    <p><strong>Email:</strong> <?php echo e($user->email); ?></p>
                    <p><strong>Phone:</strong> <?php echo e($user->phone_number); ?></p>
                </div>

                <div class="loan-info">
                    <h4>Loan Information</h4>
                    <p><strong>Loan ID:</strong> <?php echo e($loan->id); ?></p>
                    <p><strong>Principal Amount:</strong> KSh <?php echo e(number_format($loan->amount, 2)); ?></p>
                    <p><strong>Outstanding Balance:</strong> KSh <?php echo e(number_format($loan->balance, 2)); ?></p>
                </div>

                <div class="transaction-info">
                    <h4>Transaction Details</h4>
                    <p><strong>Transaction ID:</strong> <?php echo e($transaction->mpesa_transaction_id ?? 'N/A'); ?></p>
                    <p><strong>Payment Method:</strong> <?php echo e($transaction->payment_method ? ucwords(str_replace('_', ' ', $transaction->payment_method)) : 'Cash'); ?></p>
                    <?php if($transaction->mpesa_phone_number): ?>
                    <p><strong>M-Pesa Phone Number:</strong> <?php echo e($transaction->mpesa_phone_number); ?></p>
                    <?php endif; ?>
                    <p><strong>Transaction Date:</strong> <?php echo e($transaction->processed_at ? $transaction->processed_at->format('d M Y H:i') : $transaction->created_at->format('d M Y H:i')); ?></p>
                    <p><strong>Description:</strong> <?php echo e($transaction->description ?? 'Loan Repayment'); ?></p>
                </div>

                <div class="receipt-total">
                    <h4 style="margin: 0; color: #247f1b;">Amount Paid</h4>
                    <p style="font-size: 24px; font-weight: bold; margin: 10px 0; color: #28a745;">
                        KSh <?php echo e(number_format($transaction->amount, 2)); ?>

                    </p>
                </div>

                <div style="border-top: 1px solid #dee2e6; padding-top: 15px; margin-top: 15px;">
                    <p style="font-size: 12px; color: #6c757d; margin: 0;">
                        <strong>Status:</strong>
                        <span style="color: #28a745; font-weight: bold;">
                            <?php echo e(ucfirst($transaction->status)); ?>

                        </span>
                    </p>
                </div>
            </div>

            <p>Your loan repayment has been processed successfully. You can view your updated loan balance in your account dashboard.</p>

            <p>You can access your account at: <a href="<?php echo e(url('/login')); ?>" class="btn">Login to Your Account</a></p>

            <p>If you have any questions about this transaction, please contact our support team with the receipt number above.</p>

            <p>Thank you for your continued commitment to your loan repayment!</p>

            <p>Best regards,<br>
            Morio Sacco Finance Department</p>
        </div>

        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Morio Sacco. All rights reserved.</p>
            <p>This is an automated receipt. Please keep this email for your records.</p>
            <p>Receipt generated on <?php echo e(now()->format('d M Y H:i')); ?></p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\emails\loan-repayment-receipt.blade.php ENDPATH**/ ?>