<?php $__env->startSection('title', 'View Occupation'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Occupation Details</h5>
                <div class="card-toolbar">
                    <a href="<?php echo e(route('occupations.edit', $occupation)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="<?php echo e(route('occupations.index')); ?>" class="btn btn-secondary btn-sm">
                        <i class="cil-arrow-left"></i> Back to Occupations
                    </a>
                </div>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-3">ID</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->id); ?></dd>

                    <dt class="col-sm-3">Name</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->name); ?></dd>

                    <dt class="col-sm-3">Description</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->description ?: 'No description provided'); ?></dd>

                    <dt class="col-sm-3">Sort Order</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->sort_order); ?></dd>

                    <dt class="col-sm-3">Status</dt>
                    <dd class="col-sm-9">
                        <span class="badge badge-<?php echo e($occupation->is_active ? 'success' : 'secondary'); ?>">
                            <?php echo e($occupation->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </dd>

                    <dt class="col-sm-3">Created At</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->created_at->format('d M Y H:i')); ?></dd>

                    <dt class="col-sm-3">Updated At</dt>
                    <dd class="col-sm-9"><?php echo e($occupation->updated_at->format('d M Y H:i')); ?></dd>
                </dl>

                <hr>

                <h6>Usage Statistics</h6>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Members Using This Occupation</span>
                                <span class="info-box-number">
                                    <?php echo e(\App\Models\Membership::where('occupation', $occupation->name)->count()); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-box">
                            <span class="info-box-icon bg-success"><i class="fas fa-percentage"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Percentage of Total Members</span>
                                <span class="info-box-number">
                                    <?php
                                        $totalMembers = \App\Models\Membership::count();
                                        $occupationCount = \App\Models\Membership::where('occupation', $occupation->name)->count();
                                        $percentage = $totalMembers > 0 ? round(($occupationCount / $totalMembers) * 100, 1) : 0;
                                    ?>
                                    <?php echo e($percentage); ?>%
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
    <small>Powered by <a href="https://zillahtechnologies.co.ke" target="_blank" class="text-decoration-none">Zillah Technologies LTD</a></small>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\occupations\show.blade.php ENDPATH**/ ?>