

<?php $__env->startSection('title', 'Member Activity Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Date Range Filter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('reports.memberActivity')); ?>" class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Start Date</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate->format('Y-m-d')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>End Date</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate->format('Y-m-d')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-search"></i> Generate Report
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Export Options -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="btn-group">
                <a href="<?php echo e(route('reports.memberActivity', array_merge(request()->query(), ['export' => 'pdf', 'format' => 'pdf']))); ?>"
                   class="btn btn-danger" target="_blank">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="<?php echo e(route('reports.memberActivity', array_merge(request()->query(), ['export' => 'excel', 'format' => 'excel']))); ?>"
                   class="btn btn-success" target="_blank">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
        </div>
    </div>

    <!-- Member Activity Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Member Activity Summary (<?php echo e($startDate->format('M d, Y')); ?> - <?php echo e($endDate->format('M d, Y')); ?>)</h3>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>Member Name</th>
                                <th>ID Number</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Joining Date</th>
                                <th>Status</th>
                                <th>Savings Balance</th>
                                <th>Loan Balance</th>
                                <th>Share Balance</th>
                                <th>Transactions</th>
                                <th>Last Activity</th>
                                <th>Total Deposits</th>
                                <th>Total Withdrawals</th>
                                <th>Net Flow</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('memberships.show', $member['member']->id)); ?>" class="text-primary">
                                        <?php echo e($member['member']->user->full_name); ?>

                                    </a>
                                </td>
                                <td><?php echo e($member['member']->user->id_number); ?></td>
                                <td><?php echo e($member['member']->user->phone_number); ?></td>
                                <td><?php echo e($member['member']->user->email); ?></td>
                                <td><?php echo e($member['member']->joining_date->format('M d, Y')); ?></td>
                                <td>
                                    <span class="badge badge-<?php echo e($member['member']->status === 'active' ? 'success' : 'secondary'); ?>">
                                        <?php echo e(ucfirst($member['member']->status)); ?>

                                    </span>
                                </td>
                                <td class="text-right">
                                    <strong>KSh <?php echo e(number_format($member['savings_balance'], 2)); ?></strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-danger">KSh <?php echo e(number_format($member['loan_balance'], 2)); ?></strong>
                                </td>
                                <td class="text-right">
                                    <strong>KSh <?php echo e(number_format($member['share_balance'], 2)); ?></strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-info"><?php echo e($member['transaction_count']); ?></span>
                                </td>
                                <td>
                                    <?php if($member['last_activity']): ?>
                                        <small class="text-muted"><?php echo e($member['last_activity']->format('M d, Y H:i')); ?></small>
                                    <?php else: ?>
                                        <small class="text-muted">Never</small>
                                    <?php endif; ?>
                                </td>
                                <td class="text-right text-success">
                                    KSh <?php echo e(number_format($member['total_deposits'], 2)); ?>

                                </td>
                                <td class="text-right text-danger">
                                    KSh <?php echo e(number_format($member['total_withdrawals'], 2)); ?>

                                </td>
                                <td class="text-right">
                                    <strong class="<?php echo e(($member['total_deposits'] - $member['total_withdrawals']) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                        KSh <?php echo e(number_format($member['total_deposits'] - $member['total_withdrawals'], 2)); ?>

                                    </strong>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="14" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-users fa-3x mb-3"></i>
                                        <h5>No Member Data Found</h5>
                                        <p>No members found for the selected period.</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <?php if(count($data) > 0): ?>
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Activity Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Members</span>
                                    <span class="info-box-number"><?php echo e(count($data)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Active Members</span>
                                    <span class="info-box-number">
                                        <?php echo e(collect($data)->where('member.status', 'active')->count()); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Savings</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format(collect($data)->sum('savings_balance'), 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-danger">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Loans</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format(collect($data)->sum('loan_balance'), 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <div class="info-box bg-primary">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Transactions</span>
                                    <span class="info-box-number"><?php echo e(collect($data)->sum('transaction_count')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-secondary">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Deposits</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format(collect($data)->sum('total_deposits'), 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-dark">
                                <div class="info-box-content">
                                    <span class="info-box-text">Net Member Flow</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format(collect($data)->sum(function($member) {
                                            return $member['total_deposits'] - $member['total_withdrawals'];
                                        }), 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\reports\member-activity.blade.php ENDPATH**/ ?>