<?php $__env->startSection('title', 'My Loans'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-money-bill-wave mr-2"></i>My Loans
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-primary">Loan Management</span>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Left Column: Loan Summary -->
                        <div class="col-md-4">
                            <div class="border-right pr-4">
                                <h5 class="text-primary mb-3">
                                    <i class="fas fa-chart-bar mr-2"></i>Loan Summary
                                </h5>

                                <div class="row mb-3">
                                    <div class="col-12">
                                        <div class="form-group mb-2">
                                            <label class="form-label small">Total Loans Applied</label>
                                            <input type="text" value="<?php echo e($loans->count()); ?>" class="form-control form-control-sm bg-light" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-6">
                                        <div class="form-group mb-2">
                                            <label class="form-label small">Active Loans</label>
                                            <input type="text" value="<?php echo e($loans->whereIn('status', ['approved', 'active'])->count()); ?>" class="form-control form-control-sm bg-light" readonly>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group mb-2">
                                            <label class="form-label small">Pending</label>
                                            <input type="text" value="<?php echo e($loans->where('status', 'pending')->count()); ?>" class="form-control form-control-sm bg-light" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-12">
                                        <div class="form-group mb-2">
                                            <label class="form-label small">Total Loan Amount</label>
                                            <input type="text" value="KSh <?php echo e(number_format($loans->sum('amount'), 2)); ?>" class="form-control form-control-sm bg-light" readonly>
                                        </div>
                                    </div>
                                </div>

                                <!-- Apply Button -->
                                <div class="mt-4">
                                    <a href="<?php echo e(route('member.loans.create')); ?>" class="btn btn-primary btn-block">
                                        <i class="fas fa-plus mr-1"></i>Apply for New Loan
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column: Loans Table -->
                        <div class="col-md-8">
                            <div class="pl-4">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h5 class="text-info mb-0">
                                        <i class="fas fa-list mr-2"></i>My Loan Applications
                                    </h5>
                                    <?php if($loans->count() > 0): ?>
                                    <button onclick="exportToPDF()" class="btn btn-danger btn-sm">
                                        <i class="fas fa-file-pdf mr-1"></i>Export to PDF
                                    </button>
                                    <?php endif; ?>
                                </div>

                                <?php if($loans->count() > 0): ?>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover table-sm">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Amount</th>
                                                    <th>Term</th>
                                                    <th>Interest</th>
                                                    <th>Monthly Payment</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <strong class="text-primary">KSh <?php echo e(number_format($loan->amount, 0)); ?></strong>
                                                    </td>
                                                    <td><?php echo e($loan->term_months); ?> months</td>
                                                    <td>
                                                        <span class="text-warning font-weight-bold"><?php echo e($loan->interest_rate); ?>%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success font-weight-bold">KSh <?php echo e(number_format($loan->monthly_payment, 0)); ?></span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-sm
                                                            <?php if($loan->status === 'approved'): ?> badge-success
                                                            <?php elseif($loan->status === 'pending'): ?> badge-warning
                                                            <?php elseif($loan->status === 'rejected'): ?> badge-danger
                                                            <?php else: ?> badge-info <?php endif; ?>">
                                                            <?php echo e(ucfirst($loan->status)); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group btn-group-sm">
                                                            <a href="<?php echo e(route('member.loans.show', $loan)); ?>" class="btn btn-outline-primary btn-xs" title="View Details">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <?php if($loan->status === 'pending'): ?>
                                                            <a href="<?php echo e(route('member.loans.edit', $loan)); ?>" class="btn btn-outline-warning btn-xs" title="Edit Application">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <button onclick="deleteLoan(<?php echo e($loan->id); ?>)" class="btn btn-outline-danger btn-xs" title="Delete Application">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                            <?php elseif($loan->status === 'approved' || $loan->status === 'active'): ?>
                                                            <button onclick="payLoan(<?php echo e($loan->id); ?>)" class="btn btn-outline-success btn-xs" title="Make Payment">
                                                                <i class="fas fa-credit-card"></i>
                                                            </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center mt-3">
                                        <?php echo e($loans->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <!-- Empty State -->
                                    <div class="text-center py-5">
                                        <i class="fas fa-money-bill-wave fa-3x text-muted mb-3"></i>
                                        <h5 class="text-muted mb-2">No Loan Applications Yet</h5>
                                        <p class="text-muted mb-3">You haven't applied for any loans yet. Start your financial journey with us!</p>
                                        <a href="<?php echo e(route('member.loans.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus mr-2"></i>Apply for Your First Loan
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentModalLabel">
                    <i class="fas fa-credit-card mr-2"></i>Make Loan Payment
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="paymentForm" onsubmit="submitPayment(event)">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="payment_amount" class="form-label">Payment Amount (KSh)</label>
                        <input type="number" id="payment_amount" name="amount" min="1" step="0.01"
                               class="form-control" placeholder="Enter payment amount" required>
                        <small class="form-text text-muted">Enter the amount you want to pay towards your loan</small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane mr-1"></i>Send M-Pesa Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
let currentLoanId = null;

function payLoan(loanId) {
    currentLoanId = loanId;
    $('#payment_amount').val(''); // Clear previous value
    $('#paymentModal').modal('show');
}

function submitPayment(event) {
    event.preventDefault();

    const formData = new FormData(event.target);
    formData.append('loan_id', currentLoanId);

    $.ajax({
        url: `<?php echo e(url('member/loans')); ?>/${currentLoanId}/pay`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Payment Initiated!',
                    text: 'Please check your phone and complete the M-Pesa payment.',
                    timer: 3000,
                    showConfirmButton: false
                });
                $('#paymentModal').modal('hide');
                $('#paymentForm')[0].reset();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Payment Failed',
                    text: data.message
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while processing your payment.'
            });
        }
    });
}

// Reset form when modal is hidden
$('#paymentModal').on('hidden.bs.modal', function() {
    $('#paymentForm')[0].reset();
    currentLoanId = null;
});

function deleteLoan(loanId) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'This will permanently delete your loan application. This action cannot be undone.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Deleting...',
                text: 'Please wait while we delete your application.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });

            // Create form for DELETE request
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `<?php echo e(url('member/loans')); ?>/${loanId}`;
            form.style.display = 'none';

            // Add method spoofing for DELETE
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            form.appendChild(methodInput);

            // Add CSRF token
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);

            // Add to body and submit
            document.body.appendChild(form);
            form.submit();
        }
    });
}

function exportToPDF() {
    // Show loading state
    const exportBtn = $('button[onclick="exportToPDF()"]');
    const originalText = exportBtn.html();
    exportBtn.html('<i class="fas fa-spinner fa-spin mr-1"></i>Generating...').prop('disabled', true);

    // Create a form to submit the export request
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route("member.loans.export")); ?>';
    form.target = '_blank';

    // Add CSRF token
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = '<?php echo e(csrf_token()); ?>';
    form.appendChild(csrfToken);

    // Add to body and submit
    document.body.appendChild(form);
    form.submit();

    // Remove form and restore button
    setTimeout(() => {
        document.body.removeChild(form);
        exportBtn.html(originalText).prop('disabled', false);
    }, 1000);
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\member\loans\index.blade.php ENDPATH**/ ?>