<?php $__env->startSection('title', 'Edit Money Market Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Money Market Account: <?php echo e($moneyMarketAccount->account_number); ?></h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('money-market-accounts.show', $moneyMarketAccount)); ?>" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View
                        </a>
                        <a href="<?php echo e(route('money-market-accounts.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <form action="<?php echo e(route('money-market-accounts.update', $moneyMarketAccount)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Note:</strong> Only interest rate and notes can be modified for active accounts.
                            Principal amount, term, and dates cannot be changed once the account is created.
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account Number</label>
                                    <input type="text" class="form-control" value="<?php echo e($moneyMarketAccount->account_number); ?>" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Member</label>
                                    <input type="text" class="form-control" value="<?php echo e($moneyMarketAccount->membership->user->full_name ?? 'N/A'); ?> (<?php echo e($moneyMarketAccount->membership->membership_number); ?>)" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Principal Amount</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo e(\App\Helpers\CurrencyHelper::getSymbol($moneyMarketAccount->currency_code)); ?></span>
                                        </div>
                                        <input type="text" class="form-control" value="<?php echo e(number_format($moneyMarketAccount->principal_amount, 2)); ?>" readonly>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interest_rate">Interest Rate (%) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="interest_rate" id="interest_rate" class="form-control <?php $__errorArgs = ['interest_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               value="<?php echo e(old('interest_rate', $moneyMarketAccount->interest_rate)); ?>" min="0" max="50" step="0.01" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                    <?php $__errorArgs = ['interest_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Term</label>
                                    <input type="text" class="form-control" value="<?php echo e($moneyMarketAccount->term_months); ?> months" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status</label>
                                    <input type="text" class="form-control" value="<?php echo e(ucfirst($moneyMarketAccount->status)); ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Start Date</label>
                                    <input type="text" class="form-control" value="<?php echo e($moneyMarketAccount->start_date->format('M d, Y')); ?>" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Maturity Date</label>
                                    <input type="text" class="form-control" value="<?php echo e($moneyMarketAccount->maturity_date->format('M d, Y')); ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">Notes</label>
                                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3"
                                              placeholder="Optional notes about this investment"><?php echo e(old('notes', $moneyMarketAccount->notes)); ?></textarea>
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Current Financial Summary -->
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary">
                                        <h5 class="card-title mb-0">Current Financial Summary</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <strong>Principal Amount:</strong><br>
                                                <?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code)); ?>

                                            </div>
                                            <div class="col-md-4">
                                                <strong>Interest Earned:</strong><br>
                                                <?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->interest_earned, $moneyMarketAccount->currency_code)); ?>

                                            </div>
                                            <div class="col-md-4">
                                                <strong>Total Amount:</strong><br>
                                                <?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->total_amount, $moneyMarketAccount->currency_code)); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Account
                        </button>
                        <a href="<?php echo e(route('money-market-accounts.show', $moneyMarketAccount)); ?>" class="btn btn-secondary ml-2">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\money-market-accounts\edit.blade.php ENDPATH**/ ?>