<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Morio Sacco - Money Market Accounts Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 10px;
        }
        .title {
            font-size: 24px;
            font-weight: bold;
            color: #247f1b;
            margin: 10px 0;
        }
        .subtitle {
            font-size: 14px;
            color: #666;
        }
        .report-info {
            margin-bottom: 30px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
            width: 200px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 10px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }
        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            font-size: 9px;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .qr-code {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 80px;
            height: 80px;
        }
        .stats {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .stats h4 {
            margin-top: 0;
            color: #247f1b;
        }
        .currency {
            font-weight: bold;
            color: #247f1b;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">Morio Sacco</div>
        <div class="subtitle">Money Market Accounts Report</div>
        <div class="subtitle">Generated on <?php echo e(date('F j, Y \a\t g:i A')); ?></div>
    </div>

    <div class="report-info">
        <div class="info-row">
            <span class="info-label">Total Accounts:</span>
            <span><?php echo e($moneyMarketAccounts->count()); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Active Accounts:</span>
            <span><?php echo e($moneyMarketAccounts->where('status', 'active')->count()); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Principal Amount:</span>
            <span class="currency"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccounts->sum('principal_amount'))); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Interest Earned:</span>
            <span class="currency"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccounts->sum('interest_earned'))); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Portfolio Value:</span>
            <span class="currency"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccounts->sum('total_amount'))); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Report Date:</span>
            <span><?php echo e(date('Y-m-d H:i:s')); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Generated By:</span>
            <span><?php echo e(auth()->user()->full_name ?? 'System'); ?></span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Account #</th>
                <th>Member</th>
                <th>Membership #</th>
                <th>Principal</th>
                <th>Rate</th>
                <th>Type</th>
                <th>Term</th>
                <th>Interest</th>
                <th>Total</th>
                <th>Start Date</th>
                <th>Maturity</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $moneyMarketAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($account->id); ?></td>
                <td><?php echo e($account->account_number); ?></td>
                <td><?php echo e($account->membership->user->full_name ?? 'N/A'); ?></td>
                <td><?php echo e($account->membership->membership_number ?? 'N/A'); ?></td>
                <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->principal_amount, $account->currency_code)); ?></td>
                <td><?php echo e(number_format($account->interest_rate, 2)); ?>%</td>
                <td><?php echo e(ucfirst($account->interest_type)); ?></td>
                <td><?php echo e($account->term_months); ?>m</td>
                <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->interest_earned, $account->currency_code)); ?></td>
                <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->total_amount, $account->currency_code)); ?></td>
                <td><?php echo e($account->start_date->format('M d, Y')); ?></td>
                <td><?php echo e($account->maturity_date->format('M d, Y')); ?></td>
                <td><?php echo e(ucfirst($account->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="stats">
        <h4>Investment Summary</h4>
        <div class="info-row">
            <span class="info-label">Average Interest Rate:</span>
            <span><?php echo e($moneyMarketAccounts->count() > 0 ? number_format($moneyMarketAccounts->avg('interest_rate'), 2) : 0); ?>%</span>
        </div>
        <div class="info-row">
            <span class="info-label">Average Term:</span>
            <span><?php echo e($moneyMarketAccounts->count() > 0 ? number_format($moneyMarketAccounts->avg('term_months'), 1) : 0); ?> months</span>
        </div>
        <div class="info-row">
            <span class="info-label">Highest Principal:</span>
            <span><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccounts->max('principal_amount'))); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Most Profitable Account:</span>
            <span><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccounts->max('interest_earned'))); ?> interest earned</span>
        </div>
        <div class="info-row">
            <span class="info-label">Accounts Nearing Maturity:</span>
            <span><?php echo e($moneyMarketAccounts->where('maturity_date', '<=', now()->addDays(30))->count()); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Compound Interest Accounts:</span>
            <span><?php echo e($moneyMarketAccounts->where('interest_type', 'compound')->count()); ?></span>
        </div>
    </div>

    <div class="footer">
        <p><strong><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> <?php echo e(\App\Models\SystemSetting::get('contact_phone', '+254 700 000 000')); ?> |
            <i class="fas fa-envelope"></i> <?php echo e(\App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke')); ?> |
            <i class="fas fa-map-marker-alt"></i> <?php echo e(\App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya')); ?>

        </p>
        <p>
            <i class="fas fa-globe"></i> <?php echo e(\App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke')); ?> |
            Report generated on <?php echo e(now()->format('l, F j, Y \a\t g:i A')); ?> | Confidential Document
        </p>
        <p>© <?php echo e(date('Y')); ?> <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?>. All rights reserved.</p>
    </div>

    <!-- QR Code for App URL -->
    <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo e(urlencode($appUrl)); ?>" alt="QR Code" class="qr-code">
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\money-market-accounts\exports\pdf.blade.php ENDPATH**/ ?>