<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Loan Payment Schedule - Morio Sacco</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            border-bottom: 3px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
        }

        .logo {
            width: 60px;
            height: 60px;
            background-color: #247f1b;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 18px;
            margin-right: 15px;
        }

        .company-info h1 {
            color: #247f1b;
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }

        .company-info p {
            margin: 5px 0;
            color: #666;
            font-size: 14px;
        }

        .member-details {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-left: 4px solid #247f1b;
        }

        .member-details h3 {
            color: #247f1b;
            margin-top: 0;
            margin-bottom: 15px;
            font-size: 16px;
        }

        .details-grid {
            display: table;
            width: 100%;
        }

        .details-row {
            display: table-row;
        }

        .details-cell {
            display: table-cell;
            padding: 4px 0;
            vertical-align: top;
        }

        .details-label {
            font-weight: bold;
            width: 140px;
            color: #555;
        }

        .details-value {
            color: #333;
        }

        .loan-summary {
            background-color: #e8f5e8;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border: 2px solid #247f1b;
        }

        .loan-summary h3 {
            color: #247f1b;
            margin-top: 0;
            margin-bottom: 15px;
            font-size: 16px;
            text-align: center;
        }

        .summary-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }

        .summary-row {
            display: table-row;
        }

        .summary-cell {
            display: table-cell;
            text-align: center;
            padding: 8px;
            border: 1px solid #ddd;
        }

        .summary-header {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
        }

        .schedule-title {
            text-align: center;
            color: #247f1b;
            font-size: 18px;
            font-weight: bold;
            margin: 25px 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #247f1b;
        }

        .schedule-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .schedule-table th,
        .schedule-table td {
            border: 1px solid #ddd;
            padding: 8px 6px;
            text-align: center;
            vertical-align: middle;
        }

        .schedule-table th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            font-size: 11px;
        }

        .schedule-table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .schedule-table tbody tr:hover {
            background-color: #f0f8f0;
        }

        .total-row {
            background-color: #247f1b !important;
            color: white !important;
            font-weight: bold !important;
        }

        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #247f1b;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .important-notes {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
        }

        .important-notes h4 {
            color: #856404;
            margin-top: 0;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .important-notes ul {
            margin: 0;
            padding-left: 20px;
        }

        .important-notes li {
            margin-bottom: 5px;
            color: #856404;
        }

        .currency {
            font-weight: bold;
            color: #247f1b;
        }

        @media print {
            body {
                padding: 15px;
            }
            .schedule-table {
                font-size: 10px;
            }
            .schedule-table th,
            .schedule-table td {
                padding: 6px 4px;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="logo-section">
            <div class="logo">MS</div>
            <div class="company-info">
                <h1>Morio Sacco</h1>
                <p>Society Limited</p>
                <p>Loan Payment Schedule</p>
            </div>
        </div>
    </div>

    <!-- Member Details -->
    <div class="member-details">
        <h3>Member Information</h3>
        <div class="details-grid">
            <div class="details-row">
                <div class="details-cell details-label">Member Name:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->full_name); ?></div>
                <div class="details-cell details-label">Membership ID:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->membership->membership_number ?? 'N/A'); ?></div>
            </div>
            <div class="details-row">
                <div class="details-cell details-label">ID Number:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->id_number); ?></div>
                <div class="details-cell details-label">Phone Number:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->phone_number); ?></div>
            </div>
            <div class="details-row">
                <div class="details-cell details-label">Email Address:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->email); ?></div>
                <div class="details-cell details-label">Branch:</div>
                <div class="details-cell details-value"><?php echo e($loan->user->branch->name ?? 'N/A'); ?></div>
            </div>
            <div class="details-row">
                <div class="details-cell details-label">Application Date:</div>
                <div class="details-cell details-value"><?php echo e($loan->created_at->format('d M Y')); ?></div>
                <div class="details-cell details-label">Approval Date:</div>
                <div class="details-cell details-value"><?php echo e($loan->approved_at ? $loan->approved_at->format('d M Y') : 'Not Approved'); ?></div>
            </div>
        </div>
    </div>

    <!-- Loan Summary -->
    <div class="loan-summary">
        <h3>Loan Summary</h3>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell summary-header">Loan Amount</div>
                <div class="summary-cell summary-header">Interest Rate</div>
                <div class="summary-cell summary-header">Term</div>
                <div class="summary-cell summary-header">Total Amount</div>
            </div>
            <div class="summary-row">
                <div class="summary-cell"><span class="currency">KSh <?php echo e(number_format($loan->amount, 2)); ?></span></div>
                <div class="summary-cell"><?php echo e($loan->interest_rate); ?>%</div>
                <div class="summary-cell"><?php echo e($loan->term_months); ?> Months</div>
                <div class="summary-cell"><span class="currency">KSh <?php echo e(number_format($loan->total_amount, 2)); ?></span></div>
            </div>
        </div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell summary-header">Monthly Payment</div>
                <div class="summary-cell summary-header">Total Interest</div>
                <div class="summary-cell summary-header">Status</div>
                <div class="summary-cell summary-header">Loan ID</div>
            </div>
            <div class="summary-row">
                <div class="summary-cell"><span class="currency">KSh <?php echo e(number_format($loan->monthly_payment, 2)); ?></span></div>
                <div class="summary-cell"><span class="currency">KSh <?php echo e(number_format($loan->total_amount - $loan->amount, 2)); ?></span></div>
                <div class="summary-cell"><?php echo e(ucfirst($loan->status)); ?></div>
                <div class="summary-cell"><?php echo e($loan->id); ?></div>
            </div>
        </div>
    </div>

    <!-- Important Notes -->
    <div class="important-notes">
        <h4>Important Payment Information</h4>
        <ul>
            <li>Payments are due on the 1st of each month</li>
            <li>Late payments may incur additional charges</li>
            <li>All payments should be made to Morio Sacco official accounts</li>
            <li>Keep this schedule for your records</li>
            <li>Contact your branch for any payment-related queries</li>
        </ul>
    </div>

    <!-- Payment Schedule -->
    <h2 class="schedule-title">Monthly Payment Schedule</h2>

    <table class="schedule-table">
        <thead>
            <tr>
                <th style="width: 8%;">Month</th>
                <th style="width: 15%;">Due Date</th>
                <th style="width: 19%;">Payment Amount</th>
                <th style="width: 19%;">Principal</th>
                <th style="width: 19%;">Interest</th>
                <th style="width: 20%;">Remaining Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $scheduleData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($payment['month']); ?></td>
                <td><?php echo e($payment['due_date']); ?></td>
                <td><strong>KSh <?php echo e(number_format($payment['payment'], 2)); ?></strong></td>
                <td>KSh <?php echo e(number_format($payment['principal'], 2)); ?></td>
                <td>KSh <?php echo e(number_format($payment['interest'], 2)); ?></td>
                <td><strong>KSh <?php echo e(number_format($payment['balance'], 2)); ?></strong></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="2" style="text-align: right; font-weight: bold;">TOTALS:</td>
                <td><strong>KSh <?php echo e(number_format($loan->total_amount, 2)); ?></strong></td>
                <td><strong>KSh <?php echo e(number_format($loan->amount, 2)); ?></strong></td>
                <td><strong>KSh <?php echo e(number_format($loan->total_amount - $loan->amount, 2)); ?></strong></td>
                <td><strong>KSh 0.00</strong></td>
            </tr>
        </tfoot>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p><strong>Morio Sacco Society Limited</strong></p>
        <p>Generated on <?php echo e(date('d M Y \a\t H:i')); ?> | Loan ID: <?php echo e($loan->id); ?></p>
        <p>This is an official payment schedule document. Please keep it safe for reference.</p>
        <hr style="border: none; border-top: 1px solid #ddd; margin: 10px 0;">
        <p style="font-size: 9px; color: #888;">
            For any queries, contact: info@morio-sacco.co.ke | Phone: +254 XXX XXX XXX
        </p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\loans\exports\schedule.blade.php ENDPATH**/ ?>