<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Morio Sacco - Branches Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 10px;
        }
        .title {
            font-size: 24px;
            font-weight: bold;
            color: #247f1b;
            margin: 10px 0;
        }
        .subtitle {
            font-size: 14px;
            color: #666;
        }
        .report-info {
            margin-bottom: 30px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
            width: 150px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .qr-code {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 80px;
            height: 80px;
        }
        .stats {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .stats h4 {
            margin-top: 0;
            color: #247f1b;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">Morio Sacco</div>
        <div class="subtitle">Branches Report</div>
        <div class="subtitle">Generated on <?php echo e(date('F j, Y \a\t g:i A')); ?></div>
    </div>

    <div class="report-info">
        <div class="info-row">
            <span class="info-label">Total Branches:</span>
            <span><?php echo e($branches->count()); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Members:</span>
            <span><?php echo e($branches->sum('users_count')); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Report Date:</span>
            <span><?php echo e(date('Y-m-d H:i:s')); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Generated By:</span>
            <span><?php echo e(auth()->user()->full_name ?? 'System'); ?></span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Branch Name</th>
                <th>Location</th>
                <th>Description</th>
                <th>Members</th>
                <th>Created Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($branch->id); ?></td>
                <td><?php echo e($branch->name); ?></td>
                <td><?php echo e($branch->location); ?></td>
                <td><?php echo e($branch->description ?? 'N/A'); ?></td>
                <td><?php echo e($branch->users_count); ?></td>
                <td><?php echo e($branch->created_at->format('Y-m-d')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="stats">
        <h4>Summary Statistics</h4>
        <div class="info-row">
            <span class="info-label">Average Members per Branch:</span>
            <span><?php echo e($branches->count() > 0 ? round($branches->sum('users_count') / $branches->count(), 1) : 0); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Largest Branch:</span>
            <span><?php echo e($branches->sortByDesc('users_count')->first()->name ?? 'N/A'); ?> (<?php echo e($branches->max('users_count')); ?> members)</span>
        </div>
        <div class="info-row">
            <span class="info-label">Newest Branch:</span>
            <span><?php echo e($branches->sortByDesc('created_at')->first()->name ?? 'N/A'); ?></span>
        </div>
    </div>

    <div class="footer">
        <p><strong><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> <?php echo e(\App\Models\SystemSetting::get('contact_phone', '+254 700 000 000')); ?> |
            <i class="fas fa-envelope"></i> <?php echo e(\App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke')); ?> |
            <i class="fas fa-map-marker-alt"></i> <?php echo e(\App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya')); ?>

        </p>
        <p>
            <i class="fas fa-globe"></i> <?php echo e(\App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke')); ?> |
            Report generated on <?php echo e(now()->format('l, F j, Y \a\t g:i A')); ?> | Confidential Document
        </p>
        <p>© <?php echo e(date('Y')); ?> <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?>. All rights reserved.</p>
    </div>

    <!-- QR Code for App URL -->
    <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo e(urlencode($appUrl)); ?>" alt="QR Code" class="qr-code">
</body>
</html>

<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\branches\exports\pdf.blade.php ENDPATH**/ ?>